<?php

namespace LaGangaServices\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Registrar ServiceType
 * @package LaGangaServices
 * @subpackage Services
 */
class LaGangaServicesRegistrar extends AbstractSoapClientBase
{
    /**
     * Sets the ValidarUsuario SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \LaGangaServices\StructType\LaGangaServicesValidarUsuario $validarUsuario
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderValidarUsuario(\LaGangaServices\StructType\LaGangaServicesValidarUsuario $validarUsuario, $nameSpace = 'http://tempuri.org/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ValidarUsuario', $validarUsuario, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named RegistrarPedido
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ValidarUsuario
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \LaGangaServices\StructType\LaGangaServicesValidarUsuario
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LaGangaServices\StructType\LaGangaServicesRegistrarPedido $parameters
     * @return \LaGangaServices\StructType\LaGangaServicesRegistrarPedidoResponse|bool
     */
    public function RegistrarPedido(\LaGangaServices\StructType\LaGangaServicesRegistrarPedido $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RegistrarPedido($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RegistrarFacturaInternet
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ValidarUsuario
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \LaGangaServices\StructType\LaGangaServicesValidarUsuario
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LaGangaServices\StructType\LaGangaServicesRegistrarFacturaInternet $parameters
     * @return \LaGangaServices\StructType\LaGangaServicesRegistrarFacturaInternetResponse|bool
     */
    public function RegistrarFacturaInternet(\LaGangaServices\StructType\LaGangaServicesRegistrarFacturaInternet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RegistrarFacturaInternet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RegistrarCambioPrecio
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ValidarUsuario
     * - SOAPHeaderNamespaces: http://tempuri.org/
     * - SOAPHeaderTypes: \LaGangaServices\StructType\LaGangaServicesValidarUsuario
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LaGangaServices\StructType\LaGangaServicesRegistrarCambioPrecio $parameters
     * @return \LaGangaServices\StructType\LaGangaServicesRegistrarCambioPrecioResponse|bool
     */
    public function RegistrarCambioPrecio(\LaGangaServices\StructType\LaGangaServicesRegistrarCambioPrecio $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RegistrarCambioPrecio($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LaGangaServices\StructType\LaGangaServicesRegistrarCambioPrecioResponse|\LaGangaServices\StructType\LaGangaServicesRegistrarFacturaInternetResponse|\LaGangaServices\StructType\LaGangaServicesRegistrarPedidoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
