<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://mtu03-ohgl-prod.hospitality.oracleindustry.com/ws/services/StoredValueService?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://mtu03-ohgl-prod.hospitality.oracleindustry.com/ws/services/StoredValueService?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Wntechs\ClassMap::get(),
);
/**
 * Samples for Process ServiceType
 */
$process = new \Wntechs\ServiceType\Process($options);
/**
 * Sample call for processERequest operation/method
 */
if ($process->processERequest($in0, $in1, $in2, $in3) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Sample call for processCRequest operation/method
 */
if ($process->processCRequest($in0, $in1, $in2, $in3) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Sample call for processRequest operation/method
 */
if ($process->processRequest($in0, $in1, $in2, $in3) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
