<?php

namespace Wntechs\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Process ServiceType
 * @subpackage Services
 */
class Process extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named processERequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $in0
     * @param string $in1
     * @param string $in2
     * @param string $in3
     * @return string|bool
     */
    public function processERequest($in0, $in1, $in2, $in3)
    {
        try {
            $this->setResult($this->getSoapClient()->processERequest($in0, $in1, $in2, $in3));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named processCRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $in0
     * @param string $in1
     * @param string $in2
     * @param string $in3
     * @return string|bool
     */
    public function processCRequest($in0, $in1, $in2, $in3)
    {
        try {
            $this->setResult($this->getSoapClient()->processCRequest($in0, $in1, $in2, $in3));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named processRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $in0
     * @param string $in1
     * @param string $in2
     * @param string $in3
     * @return string|bool
     */
    public function processRequest($in0, $in1, $in2, $in3)
    {
        try {
            $this->setResult($this->getSoapClient()->processRequest($in0, $in1, $in2, $in3));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
