<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://dev.gittigidiyor.com:8443/listingapi/ws/IndividualProductService?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://dev.gittigidiyor.com:8443/listingapi/ws/IndividualProductService?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Calculate ServiceType
 */
$calculate = new \ServiceType\Calculate($options);
/**
 * Sample call for calculatePriceForRevision operation/method
 */
if ($calculate->calculatePriceForRevision($apiKey, $sign, $time, $productId, $itemId, $lang) !== false) {
    print_r($calculate->getResult());
} else {
    print_r($calculate->getLastError());
}
/**
 * Sample call for calculatePriceForShoppingCart operation/method
 */
if ($calculate->calculatePriceForShoppingCart($apiKey, $sign, $time, new \ArrayType\IntArray(), new \ArrayType\StringArray(), $lang) !== false) {
    print_r($calculate->getResult());
} else {
    print_r($calculate->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
/**
 * Sample call for checkForItemId operation/method
 */
if ($check->checkForItemId($apiKey, $sign, $time, $itemId, $lang) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Clone ServiceType
 */
$clone = new \ServiceType\_Clone($options);
/**
 * Sample call for cloneProduct operation/method
 */
if ($clone->cloneProduct($apiKey, $sign, $time, $productId, $itemId, $lang) !== false) {
    print_r($clone->getResult());
} else {
    print_r($clone->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for deleteProduct operation/method
 */
if ($delete->deleteProduct($apiKey, $sign, $time, new \ArrayType\IntArray(), new \ArrayType\StringArray(), $lang) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteProducts operation/method
 */
if ($delete->deleteProducts($apiKey, $sign, $time, new \ArrayType\IntArray(), new \ArrayType\StringArray(), $lang) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Finish ServiceType
 */
$finish = new \ServiceType\Finish($options);
/**
 * Sample call for finishEarly operation/method
 */
if ($finish->finishEarly($apiKey, $sign, $time, new \ArrayType\IntArray(), new \ArrayType\StringArray(), $lang) !== false) {
    print_r($finish->getResult());
} else {
    print_r($finish->getLastError());
}
/**
 * Sample call for finishEarlyProducts operation/method
 */
if ($finish->finishEarlyProducts($apiKey, $sign, $time, new \ArrayType\IntArray(), new \ArrayType\StringArray(), $lang) !== false) {
    print_r($finish->getResult());
} else {
    print_r($finish->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getItemIdDetails operation/method
 */
if ($get->getItemIdDetails($apiKey, $sign, $time, new \ArrayType\IntArray(), $lang) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNewlyListedProductIdList operation/method
 */
if ($get->getNewlyListedProductIdList($apiKey, $sign, $time, $startOffSet, $rowCount, $viaApi, $lang) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProduct operation/method
 */
if ($get->getProduct($apiKey, $sign, $time, $productId, $itemId, $lang) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProductDescription operation/method
 */
if ($get->getProductDescription($apiKey, $sign, $time, $productId, $itemId, $lang) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProductFinishReasonListByAuthenticatedUser operation/method
 */
if ($get->getProductFinishReasonListByAuthenticatedUser($apiKey, $sign, $time, $startOffSet, $rowCount, $lang) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProductIds operation/method
 */
if ($get->getProductIds($apiKey, $sign, $time, $startOffSet, $rowCount, new \ArrayType\StringArray(), $lang) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProductImageStatus operation/method
 */
if ($get->getProductImageStatus($apiKey, $sign, $time, $productId, $lang) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProductSpecs operation/method
 */
if ($get->getProductSpecs($apiKey, $sign, $time, $productId, $itemId, $lang) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProductStatuses operation/method
 */
if ($get->getProductStatuses($apiKey, $sign, $time, new \ArrayType\IntArray(), new \ArrayType\StringArray(), $lang) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProductVariants operation/method
 */
if ($get->getProductVariants($apiKey, $sign, $time, $productId, $itemId, $variantId, $variantStockCode, $lang) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProducts operation/method
 */
if ($get->getProducts($apiKey, $sign, $time, $startOffSet, $rowCount, $status, $withData, $lang) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProductsByIds operation/method
 */
if ($get->getProductsByIds($apiKey, $sign, $time, new \ArrayType\IntArray(), new \ArrayType\StringArray(), $withData, $lang) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getServiceName operation/method
 */
if ($get->getServiceName() !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getStockAndPrice operation/method
 */
if ($get->getStockAndPrice($apiKey, $sign, $time, new \ArrayType\IntArray(), new \ArrayType\StringArray(), $lang) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Insert ServiceType
 */
$insert = new \ServiceType\Insert($options);
/**
 * Sample call for insertProduct operation/method
 */
if ($insert->insertProduct($apiKey, $sign, $time, $itemId, new \StructType\ProductType(), $forceToSpecEntry, $nextDateOption, $lang) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for insertProductWithNewCargoDetail operation/method
 */
if ($insert->insertProductWithNewCargoDetail($apiKey, $sign, $time, $itemId, new \StructType\ProductType(), $forceToSpecEntry, $nextDateOption, $lang) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for insertRetailProduct operation/method
 */
if ($insert->insertRetailProduct($apiKey, $sign, $time, $itemId, new \StructType\ProductType(), $forceToSpecEntry, $nextDateOption, $lang) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for insertRetailProductWithNewCargoDetail operation/method
 */
if ($insert->insertRetailProductWithNewCargoDetail($apiKey, $sign, $time, $itemId, new \StructType\ProductType(), $forceToSpecEntry, $nextDateOption, $lang) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Samples for Pay ServiceType
 */
$pay = new \ServiceType\Pay($options);
/**
 * Sample call for payPrice operation/method
 */
if ($pay->payPrice($apiKey, $sign, $time, $voucher, $ccOwnerName, $ccOwnerSurname, $ccNumber, $cvv, $expireMonth, $expireYear, $lang) !== false) {
    print_r($pay->getResult());
} else {
    print_r($pay->getLastError());
}
/**
 * Samples for Relist ServiceType
 */
$relist = new \ServiceType\Relist($options);
/**
 * Sample call for relistProducts operation/method
 */
if ($relist->relistProducts($apiKey, $sign, $time, new \ArrayType\IntArray(), new \ArrayType\StringArray(), $lang) !== false) {
    print_r($relist->getResult());
} else {
    print_r($relist->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for updateItemId operation/method
 */
if ($update->updateItemId($apiKey, $sign, $time, $productId, $itemId, $lang) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateMarketPrice operation/method
 */
if ($update->updateMarketPrice($apiKey, $sign, $time, $productId, $marketPrice, $lang) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updatePrice operation/method
 */
if ($update->updatePrice($apiKey, $sign, $time, $productId, $itemId, $price, $cancelBid, $lang) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updatePriceByPercentage operation/method
 */
if ($update->updatePriceByPercentage($apiKey, $sign, $time, $productId, $itemId, $operatorType, $percentage, $lang) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateProduct operation/method
 */
if ($update->updateProduct($apiKey, $sign, $time, $itemId, $productId, new \StructType\ProductType(), $onSale, $forceToSpecEntry, $nextDateOption, $lang) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateProductVariants operation/method
 */
if ($update->updateProductVariants($apiKey, $sign, $time, $productId, $itemId, new \StructType\ProductVariantType(), $lang) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateProductWithNewCargoDetail operation/method
 */
if ($update->updateProductWithNewCargoDetail($apiKey, $sign, $time, $itemId, $productId, new \StructType\ProductType(), $onSale, $forceToSpecEntry, $nextDateOption, $lang) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateProductWithVariants operation/method
 */
if ($update->updateProductWithVariants($apiKey, $sign, $time, $itemId, $productId, new \StructType\ProductType(), $onSale, $forceToSpecEntry, $nextDateOption, $lang) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateStock operation/method
 */
if ($update->updateStock($apiKey, $sign, $time, $productId, $itemId, $stock, $cancelBid, $lang) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateVariantStock operation/method
 */
if ($update->updateVariantStock($apiKey, $sign, $time, $productId, $itemId, $variantId, $stock, $lang) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
