<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for variantGroupType StructType
 * @subpackage Structs
 */
class VariantGroupType extends AbstractStructBase
{
    /**
     * The variants
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Variants
     */
    public $variants;
    /**
     * The photos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Photos
     */
    public $photos;
    /**
     * The nameId
     * @var int
     */
    public $nameId;
    /**
     * The valueId
     * @var int
     */
    public $valueId;
    /**
     * The alias
     * @var string
     */
    public $alias;
    /**
     * Constructor method for variantGroupType
     * @uses VariantGroupType::setVariants()
     * @uses VariantGroupType::setPhotos()
     * @uses VariantGroupType::setNameId()
     * @uses VariantGroupType::setValueId()
     * @uses VariantGroupType::setAlias()
     * @param \StructType\Variants $variants
     * @param \StructType\Photos $photos
     * @param int $nameId
     * @param int $valueId
     * @param string $alias
     */
    public function __construct(\StructType\Variants $variants = null, \StructType\Photos $photos = null, $nameId = null, $valueId = null, $alias = null)
    {
        $this
            ->setVariants($variants)
            ->setPhotos($photos)
            ->setNameId($nameId)
            ->setValueId($valueId)
            ->setAlias($alias);
    }
    /**
     * Get variants value
     * @return \StructType\Variants|null
     */
    public function getVariants()
    {
        return $this->variants;
    }
    /**
     * Set variants value
     * @param \StructType\Variants $variants
     * @return \StructType\VariantGroupType
     */
    public function setVariants(\StructType\Variants $variants = null)
    {
        $this->variants = $variants;
        return $this;
    }
    /**
     * Get photos value
     * @return \StructType\Photos|null
     */
    public function getPhotos()
    {
        return $this->photos;
    }
    /**
     * Set photos value
     * @param \StructType\Photos $photos
     * @return \StructType\VariantGroupType
     */
    public function setPhotos(\StructType\Photos $photos = null)
    {
        $this->photos = $photos;
        return $this;
    }
    /**
     * Get nameId value
     * @return int|null
     */
    public function getNameId()
    {
        return $this->nameId;
    }
    /**
     * Set nameId value
     * @param int $nameId
     * @return \StructType\VariantGroupType
     */
    public function setNameId($nameId = null)
    {
        // validation for constraint: int
        if (!is_null($nameId) && !(is_int($nameId) || ctype_digit($nameId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nameId, true), gettype($nameId)), __LINE__);
        }
        $this->nameId = $nameId;
        return $this;
    }
    /**
     * Get valueId value
     * @return int|null
     */
    public function getValueId()
    {
        return $this->valueId;
    }
    /**
     * Set valueId value
     * @param int $valueId
     * @return \StructType\VariantGroupType
     */
    public function setValueId($valueId = null)
    {
        // validation for constraint: int
        if (!is_null($valueId) && !(is_int($valueId) || ctype_digit($valueId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($valueId, true), gettype($valueId)), __LINE__);
        }
        $this->valueId = $valueId;
        return $this;
    }
    /**
     * Get alias value
     * @return string|null
     */
    public function getAlias()
    {
        return $this->alias;
    }
    /**
     * Set alias value
     * @param string $alias
     * @return \StructType\VariantGroupType
     */
    public function setAlias($alias = null)
    {
        // validation for constraint: string
        if (!is_null($alias) && !is_string($alias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alias, true), gettype($alias)), __LINE__);
        }
        $this->alias = $alias;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VariantGroupType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
