<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productType StructType
 * @subpackage Structs
 */
class ProductType extends AbstractStructBase
{
    /**
     * The categoryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $categoryCode;
    /**
     * The storeCategoryId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $storeCategoryId;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The subtitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subtitle;
    /**
     * The specs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Specs
     */
    public $specs;
    /**
     * The photos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Photos
     */
    public $photos;
    /**
     * The pageTemplate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $pageTemplate;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The catalogId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $catalogId;
    /**
     * The newCatalogId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $newCatalogId;
    /**
     * The catalogDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $catalogDetail;
    /**
     * The catalogFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $catalogFilter;
    /**
     * The format
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $format;
    /**
     * The startPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $startPrice;
    /**
     * The buyNowPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $buyNowPrice;
    /**
     * The netEarning
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $netEarning;
    /**
     * The listingDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $listingDays;
    /**
     * The productCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $productCount;
    /**
     * The cargoDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CargoDetailType
     */
    public $cargoDetail;
    /**
     * The affiliateOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $affiliateOption;
    /**
     * The boldOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $boldOption;
    /**
     * The catalogOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $catalogOption;
    /**
     * The vitrineOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $vitrineOption;
    /**
     * The variantGroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VariantGroups
     */
    public $variantGroups;
    /**
     * The auctionProfilePercentage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $auctionProfilePercentage;
    /**
     * The marketPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $marketPrice;
    /**
     * The globalTradeItemNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $globalTradeItemNo;
    /**
     * The manufacturerPartNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $manufacturerPartNo;
    /**
     * The sameDayDeliveryTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SameDayDeliveryTypes
     */
    public $sameDayDeliveryTypes;
    /**
     * Constructor method for productType
     * @uses ProductType::setCategoryCode()
     * @uses ProductType::setStoreCategoryId()
     * @uses ProductType::setTitle()
     * @uses ProductType::setSubtitle()
     * @uses ProductType::setSpecs()
     * @uses ProductType::setPhotos()
     * @uses ProductType::setPageTemplate()
     * @uses ProductType::setDescription()
     * @uses ProductType::setStartDate()
     * @uses ProductType::setCatalogId()
     * @uses ProductType::setNewCatalogId()
     * @uses ProductType::setCatalogDetail()
     * @uses ProductType::setCatalogFilter()
     * @uses ProductType::setFormat()
     * @uses ProductType::setStartPrice()
     * @uses ProductType::setBuyNowPrice()
     * @uses ProductType::setNetEarning()
     * @uses ProductType::setListingDays()
     * @uses ProductType::setProductCount()
     * @uses ProductType::setCargoDetail()
     * @uses ProductType::setAffiliateOption()
     * @uses ProductType::setBoldOption()
     * @uses ProductType::setCatalogOption()
     * @uses ProductType::setVitrineOption()
     * @uses ProductType::setVariantGroups()
     * @uses ProductType::setAuctionProfilePercentage()
     * @uses ProductType::setMarketPrice()
     * @uses ProductType::setGlobalTradeItemNo()
     * @uses ProductType::setManufacturerPartNo()
     * @uses ProductType::setSameDayDeliveryTypes()
     * @param string $categoryCode
     * @param int $storeCategoryId
     * @param string $title
     * @param string $subtitle
     * @param \StructType\Specs $specs
     * @param \StructType\Photos $photos
     * @param int $pageTemplate
     * @param string $description
     * @param string $startDate
     * @param int $catalogId
     * @param int $newCatalogId
     * @param int $catalogDetail
     * @param string $catalogFilter
     * @param string $format
     * @param float $startPrice
     * @param float $buyNowPrice
     * @param float $netEarning
     * @param int $listingDays
     * @param int $productCount
     * @param \StructType\CargoDetailType $cargoDetail
     * @param bool $affiliateOption
     * @param bool $boldOption
     * @param bool $catalogOption
     * @param bool $vitrineOption
     * @param \StructType\VariantGroups $variantGroups
     * @param int $auctionProfilePercentage
     * @param float $marketPrice
     * @param int $globalTradeItemNo
     * @param string $manufacturerPartNo
     * @param \StructType\SameDayDeliveryTypes $sameDayDeliveryTypes
     */
    public function __construct($categoryCode = null, $storeCategoryId = null, $title = null, $subtitle = null, \StructType\Specs $specs = null, \StructType\Photos $photos = null, $pageTemplate = null, $description = null, $startDate = null, $catalogId = null, $newCatalogId = null, $catalogDetail = null, $catalogFilter = null, $format = null, $startPrice = null, $buyNowPrice = null, $netEarning = null, $listingDays = null, $productCount = null, \StructType\CargoDetailType $cargoDetail = null, $affiliateOption = null, $boldOption = null, $catalogOption = null, $vitrineOption = null, \StructType\VariantGroups $variantGroups = null, $auctionProfilePercentage = null, $marketPrice = null, $globalTradeItemNo = null, $manufacturerPartNo = null, \StructType\SameDayDeliveryTypes $sameDayDeliveryTypes = null)
    {
        $this
            ->setCategoryCode($categoryCode)
            ->setStoreCategoryId($storeCategoryId)
            ->setTitle($title)
            ->setSubtitle($subtitle)
            ->setSpecs($specs)
            ->setPhotos($photos)
            ->setPageTemplate($pageTemplate)
            ->setDescription($description)
            ->setStartDate($startDate)
            ->setCatalogId($catalogId)
            ->setNewCatalogId($newCatalogId)
            ->setCatalogDetail($catalogDetail)
            ->setCatalogFilter($catalogFilter)
            ->setFormat($format)
            ->setStartPrice($startPrice)
            ->setBuyNowPrice($buyNowPrice)
            ->setNetEarning($netEarning)
            ->setListingDays($listingDays)
            ->setProductCount($productCount)
            ->setCargoDetail($cargoDetail)
            ->setAffiliateOption($affiliateOption)
            ->setBoldOption($boldOption)
            ->setCatalogOption($catalogOption)
            ->setVitrineOption($vitrineOption)
            ->setVariantGroups($variantGroups)
            ->setAuctionProfilePercentage($auctionProfilePercentage)
            ->setMarketPrice($marketPrice)
            ->setGlobalTradeItemNo($globalTradeItemNo)
            ->setManufacturerPartNo($manufacturerPartNo)
            ->setSameDayDeliveryTypes($sameDayDeliveryTypes);
    }
    /**
     * Get categoryCode value
     * @return string|null
     */
    public function getCategoryCode()
    {
        return $this->categoryCode;
    }
    /**
     * Set categoryCode value
     * @param string $categoryCode
     * @return \StructType\ProductType
     */
    public function setCategoryCode($categoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($categoryCode) && !is_string($categoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryCode, true), gettype($categoryCode)), __LINE__);
        }
        $this->categoryCode = $categoryCode;
        return $this;
    }
    /**
     * Get storeCategoryId value
     * @return int|null
     */
    public function getStoreCategoryId()
    {
        return $this->storeCategoryId;
    }
    /**
     * Set storeCategoryId value
     * @param int $storeCategoryId
     * @return \StructType\ProductType
     */
    public function setStoreCategoryId($storeCategoryId = null)
    {
        // validation for constraint: int
        if (!is_null($storeCategoryId) && !(is_int($storeCategoryId) || ctype_digit($storeCategoryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($storeCategoryId, true), gettype($storeCategoryId)), __LINE__);
        }
        $this->storeCategoryId = $storeCategoryId;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\ProductType
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get subtitle value
     * @return string|null
     */
    public function getSubtitle()
    {
        return $this->subtitle;
    }
    /**
     * Set subtitle value
     * @param string $subtitle
     * @return \StructType\ProductType
     */
    public function setSubtitle($subtitle = null)
    {
        // validation for constraint: string
        if (!is_null($subtitle) && !is_string($subtitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subtitle, true), gettype($subtitle)), __LINE__);
        }
        $this->subtitle = $subtitle;
        return $this;
    }
    /**
     * Get specs value
     * @return \StructType\Specs|null
     */
    public function getSpecs()
    {
        return $this->specs;
    }
    /**
     * Set specs value
     * @param \StructType\Specs $specs
     * @return \StructType\ProductType
     */
    public function setSpecs(\StructType\Specs $specs = null)
    {
        $this->specs = $specs;
        return $this;
    }
    /**
     * Get photos value
     * @return \StructType\Photos|null
     */
    public function getPhotos()
    {
        return $this->photos;
    }
    /**
     * Set photos value
     * @param \StructType\Photos $photos
     * @return \StructType\ProductType
     */
    public function setPhotos(\StructType\Photos $photos = null)
    {
        $this->photos = $photos;
        return $this;
    }
    /**
     * Get pageTemplate value
     * @return int|null
     */
    public function getPageTemplate()
    {
        return $this->pageTemplate;
    }
    /**
     * Set pageTemplate value
     * @param int $pageTemplate
     * @return \StructType\ProductType
     */
    public function setPageTemplate($pageTemplate = null)
    {
        // validation for constraint: int
        if (!is_null($pageTemplate) && !(is_int($pageTemplate) || ctype_digit($pageTemplate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageTemplate, true), gettype($pageTemplate)), __LINE__);
        }
        $this->pageTemplate = $pageTemplate;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ProductType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\ProductType
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get catalogId value
     * @return int|null
     */
    public function getCatalogId()
    {
        return $this->catalogId;
    }
    /**
     * Set catalogId value
     * @param int $catalogId
     * @return \StructType\ProductType
     */
    public function setCatalogId($catalogId = null)
    {
        // validation for constraint: int
        if (!is_null($catalogId) && !(is_int($catalogId) || ctype_digit($catalogId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($catalogId, true), gettype($catalogId)), __LINE__);
        }
        $this->catalogId = $catalogId;
        return $this;
    }
    /**
     * Get newCatalogId value
     * @return int|null
     */
    public function getNewCatalogId()
    {
        return $this->newCatalogId;
    }
    /**
     * Set newCatalogId value
     * @param int $newCatalogId
     * @return \StructType\ProductType
     */
    public function setNewCatalogId($newCatalogId = null)
    {
        // validation for constraint: int
        if (!is_null($newCatalogId) && !(is_int($newCatalogId) || ctype_digit($newCatalogId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newCatalogId, true), gettype($newCatalogId)), __LINE__);
        }
        $this->newCatalogId = $newCatalogId;
        return $this;
    }
    /**
     * Get catalogDetail value
     * @return int|null
     */
    public function getCatalogDetail()
    {
        return $this->catalogDetail;
    }
    /**
     * Set catalogDetail value
     * @param int $catalogDetail
     * @return \StructType\ProductType
     */
    public function setCatalogDetail($catalogDetail = null)
    {
        // validation for constraint: int
        if (!is_null($catalogDetail) && !(is_int($catalogDetail) || ctype_digit($catalogDetail))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($catalogDetail, true), gettype($catalogDetail)), __LINE__);
        }
        $this->catalogDetail = $catalogDetail;
        return $this;
    }
    /**
     * Get catalogFilter value
     * @return string|null
     */
    public function getCatalogFilter()
    {
        return $this->catalogFilter;
    }
    /**
     * Set catalogFilter value
     * @param string $catalogFilter
     * @return \StructType\ProductType
     */
    public function setCatalogFilter($catalogFilter = null)
    {
        // validation for constraint: string
        if (!is_null($catalogFilter) && !is_string($catalogFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($catalogFilter, true), gettype($catalogFilter)), __LINE__);
        }
        $this->catalogFilter = $catalogFilter;
        return $this;
    }
    /**
     * Get format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @param string $format
     * @return \StructType\ProductType
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($format, true), gettype($format)), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Get startPrice value
     * @return float|null
     */
    public function getStartPrice()
    {
        return $this->startPrice;
    }
    /**
     * Set startPrice value
     * @param float $startPrice
     * @return \StructType\ProductType
     */
    public function setStartPrice($startPrice = null)
    {
        // validation for constraint: float
        if (!is_null($startPrice) && !(is_float($startPrice) || is_numeric($startPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($startPrice, true), gettype($startPrice)), __LINE__);
        }
        $this->startPrice = $startPrice;
        return $this;
    }
    /**
     * Get buyNowPrice value
     * @return float|null
     */
    public function getBuyNowPrice()
    {
        return $this->buyNowPrice;
    }
    /**
     * Set buyNowPrice value
     * @param float $buyNowPrice
     * @return \StructType\ProductType
     */
    public function setBuyNowPrice($buyNowPrice = null)
    {
        // validation for constraint: float
        if (!is_null($buyNowPrice) && !(is_float($buyNowPrice) || is_numeric($buyNowPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($buyNowPrice, true), gettype($buyNowPrice)), __LINE__);
        }
        $this->buyNowPrice = $buyNowPrice;
        return $this;
    }
    /**
     * Get netEarning value
     * @return float|null
     */
    public function getNetEarning()
    {
        return $this->netEarning;
    }
    /**
     * Set netEarning value
     * @param float $netEarning
     * @return \StructType\ProductType
     */
    public function setNetEarning($netEarning = null)
    {
        // validation for constraint: float
        if (!is_null($netEarning) && !(is_float($netEarning) || is_numeric($netEarning))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($netEarning, true), gettype($netEarning)), __LINE__);
        }
        $this->netEarning = $netEarning;
        return $this;
    }
    /**
     * Get listingDays value
     * @return int|null
     */
    public function getListingDays()
    {
        return $this->listingDays;
    }
    /**
     * Set listingDays value
     * @param int $listingDays
     * @return \StructType\ProductType
     */
    public function setListingDays($listingDays = null)
    {
        // validation for constraint: int
        if (!is_null($listingDays) && !(is_int($listingDays) || ctype_digit($listingDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($listingDays, true), gettype($listingDays)), __LINE__);
        }
        $this->listingDays = $listingDays;
        return $this;
    }
    /**
     * Get productCount value
     * @return int|null
     */
    public function getProductCount()
    {
        return $this->productCount;
    }
    /**
     * Set productCount value
     * @param int $productCount
     * @return \StructType\ProductType
     */
    public function setProductCount($productCount = null)
    {
        // validation for constraint: int
        if (!is_null($productCount) && !(is_int($productCount) || ctype_digit($productCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productCount, true), gettype($productCount)), __LINE__);
        }
        $this->productCount = $productCount;
        return $this;
    }
    /**
     * Get cargoDetail value
     * @return \StructType\CargoDetailType|null
     */
    public function getCargoDetail()
    {
        return $this->cargoDetail;
    }
    /**
     * Set cargoDetail value
     * @param \StructType\CargoDetailType $cargoDetail
     * @return \StructType\ProductType
     */
    public function setCargoDetail(\StructType\CargoDetailType $cargoDetail = null)
    {
        $this->cargoDetail = $cargoDetail;
        return $this;
    }
    /**
     * Get affiliateOption value
     * @return bool|null
     */
    public function getAffiliateOption()
    {
        return $this->affiliateOption;
    }
    /**
     * Set affiliateOption value
     * @param bool $affiliateOption
     * @return \StructType\ProductType
     */
    public function setAffiliateOption($affiliateOption = null)
    {
        // validation for constraint: boolean
        if (!is_null($affiliateOption) && !is_bool($affiliateOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($affiliateOption, true), gettype($affiliateOption)), __LINE__);
        }
        $this->affiliateOption = $affiliateOption;
        return $this;
    }
    /**
     * Get boldOption value
     * @return bool|null
     */
    public function getBoldOption()
    {
        return $this->boldOption;
    }
    /**
     * Set boldOption value
     * @param bool $boldOption
     * @return \StructType\ProductType
     */
    public function setBoldOption($boldOption = null)
    {
        // validation for constraint: boolean
        if (!is_null($boldOption) && !is_bool($boldOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($boldOption, true), gettype($boldOption)), __LINE__);
        }
        $this->boldOption = $boldOption;
        return $this;
    }
    /**
     * Get catalogOption value
     * @return bool|null
     */
    public function getCatalogOption()
    {
        return $this->catalogOption;
    }
    /**
     * Set catalogOption value
     * @param bool $catalogOption
     * @return \StructType\ProductType
     */
    public function setCatalogOption($catalogOption = null)
    {
        // validation for constraint: boolean
        if (!is_null($catalogOption) && !is_bool($catalogOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($catalogOption, true), gettype($catalogOption)), __LINE__);
        }
        $this->catalogOption = $catalogOption;
        return $this;
    }
    /**
     * Get vitrineOption value
     * @return bool|null
     */
    public function getVitrineOption()
    {
        return $this->vitrineOption;
    }
    /**
     * Set vitrineOption value
     * @param bool $vitrineOption
     * @return \StructType\ProductType
     */
    public function setVitrineOption($vitrineOption = null)
    {
        // validation for constraint: boolean
        if (!is_null($vitrineOption) && !is_bool($vitrineOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vitrineOption, true), gettype($vitrineOption)), __LINE__);
        }
        $this->vitrineOption = $vitrineOption;
        return $this;
    }
    /**
     * Get variantGroups value
     * @return \StructType\VariantGroups|null
     */
    public function getVariantGroups()
    {
        return $this->variantGroups;
    }
    /**
     * Set variantGroups value
     * @param \StructType\VariantGroups $variantGroups
     * @return \StructType\ProductType
     */
    public function setVariantGroups(\StructType\VariantGroups $variantGroups = null)
    {
        $this->variantGroups = $variantGroups;
        return $this;
    }
    /**
     * Get auctionProfilePercentage value
     * @return int|null
     */
    public function getAuctionProfilePercentage()
    {
        return $this->auctionProfilePercentage;
    }
    /**
     * Set auctionProfilePercentage value
     * @param int $auctionProfilePercentage
     * @return \StructType\ProductType
     */
    public function setAuctionProfilePercentage($auctionProfilePercentage = null)
    {
        // validation for constraint: int
        if (!is_null($auctionProfilePercentage) && !(is_int($auctionProfilePercentage) || ctype_digit($auctionProfilePercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auctionProfilePercentage, true), gettype($auctionProfilePercentage)), __LINE__);
        }
        $this->auctionProfilePercentage = $auctionProfilePercentage;
        return $this;
    }
    /**
     * Get marketPrice value
     * @return float|null
     */
    public function getMarketPrice()
    {
        return $this->marketPrice;
    }
    /**
     * Set marketPrice value
     * @param float $marketPrice
     * @return \StructType\ProductType
     */
    public function setMarketPrice($marketPrice = null)
    {
        // validation for constraint: float
        if (!is_null($marketPrice) && !(is_float($marketPrice) || is_numeric($marketPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($marketPrice, true), gettype($marketPrice)), __LINE__);
        }
        $this->marketPrice = $marketPrice;
        return $this;
    }
    /**
     * Get globalTradeItemNo value
     * @return int|null
     */
    public function getGlobalTradeItemNo()
    {
        return $this->globalTradeItemNo;
    }
    /**
     * Set globalTradeItemNo value
     * @param int $globalTradeItemNo
     * @return \StructType\ProductType
     */
    public function setGlobalTradeItemNo($globalTradeItemNo = null)
    {
        // validation for constraint: int
        if (!is_null($globalTradeItemNo) && !(is_int($globalTradeItemNo) || ctype_digit($globalTradeItemNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($globalTradeItemNo, true), gettype($globalTradeItemNo)), __LINE__);
        }
        $this->globalTradeItemNo = $globalTradeItemNo;
        return $this;
    }
    /**
     * Get manufacturerPartNo value
     * @return string|null
     */
    public function getManufacturerPartNo()
    {
        return $this->manufacturerPartNo;
    }
    /**
     * Set manufacturerPartNo value
     * @param string $manufacturerPartNo
     * @return \StructType\ProductType
     */
    public function setManufacturerPartNo($manufacturerPartNo = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturerPartNo) && !is_string($manufacturerPartNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturerPartNo, true), gettype($manufacturerPartNo)), __LINE__);
        }
        $this->manufacturerPartNo = $manufacturerPartNo;
        return $this;
    }
    /**
     * Get sameDayDeliveryTypes value
     * @return \StructType\SameDayDeliveryTypes|null
     */
    public function getSameDayDeliveryTypes()
    {
        return $this->sameDayDeliveryTypes;
    }
    /**
     * Set sameDayDeliveryTypes value
     * @param \StructType\SameDayDeliveryTypes $sameDayDeliveryTypes
     * @return \StructType\ProductType
     */
    public function setSameDayDeliveryTypes(\StructType\SameDayDeliveryTypes $sameDayDeliveryTypes = null)
    {
        $this->sameDayDeliveryTypes = $sameDayDeliveryTypes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
