<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productServiceRetailResponse StructType
 * @subpackage Structs
 */
class ProductServiceRetailResponse extends BaseResponse
{
    /**
     * The productId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $productId;
    /**
     * The itemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemId;
    /**
     * The payRequired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $payRequired;
    /**
     * The result
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $result;
    /**
     * The descriptionFilterStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $descriptionFilterStatus;
    /**
     * The listingStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $listingStatus;
    /**
     * Constructor method for productServiceRetailResponse
     * @uses ProductServiceRetailResponse::setProductId()
     * @uses ProductServiceRetailResponse::setItemId()
     * @uses ProductServiceRetailResponse::setPayRequired()
     * @uses ProductServiceRetailResponse::setResult()
     * @uses ProductServiceRetailResponse::setDescriptionFilterStatus()
     * @uses ProductServiceRetailResponse::setListingStatus()
     * @param int $productId
     * @param string $itemId
     * @param bool $payRequired
     * @param string $result
     * @param int $descriptionFilterStatus
     * @param string $listingStatus
     */
    public function __construct($productId = null, $itemId = null, $payRequired = null, $result = null, $descriptionFilterStatus = null, $listingStatus = null)
    {
        $this
            ->setProductId($productId)
            ->setItemId($itemId)
            ->setPayRequired($payRequired)
            ->setResult($result)
            ->setDescriptionFilterStatus($descriptionFilterStatus)
            ->setListingStatus($listingStatus);
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\ProductServiceRetailResponse
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get itemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->itemId;
    }
    /**
     * Set itemId value
     * @param string $itemId
     * @return \StructType\ProductServiceRetailResponse
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->itemId = $itemId;
        return $this;
    }
    /**
     * Get payRequired value
     * @return bool|null
     */
    public function getPayRequired()
    {
        return $this->payRequired;
    }
    /**
     * Set payRequired value
     * @param bool $payRequired
     * @return \StructType\ProductServiceRetailResponse
     */
    public function setPayRequired($payRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($payRequired) && !is_bool($payRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($payRequired, true), gettype($payRequired)), __LINE__);
        }
        $this->payRequired = $payRequired;
        return $this;
    }
    /**
     * Get result value
     * @return string|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @param string $result
     * @return \StructType\ProductServiceRetailResponse
     */
    public function setResult($result = null)
    {
        // validation for constraint: string
        if (!is_null($result) && !is_string($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->result = $result;
        return $this;
    }
    /**
     * Get descriptionFilterStatus value
     * @return int|null
     */
    public function getDescriptionFilterStatus()
    {
        return $this->descriptionFilterStatus;
    }
    /**
     * Set descriptionFilterStatus value
     * @param int $descriptionFilterStatus
     * @return \StructType\ProductServiceRetailResponse
     */
    public function setDescriptionFilterStatus($descriptionFilterStatus = null)
    {
        // validation for constraint: int
        if (!is_null($descriptionFilterStatus) && !(is_int($descriptionFilterStatus) || ctype_digit($descriptionFilterStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($descriptionFilterStatus, true), gettype($descriptionFilterStatus)), __LINE__);
        }
        $this->descriptionFilterStatus = $descriptionFilterStatus;
        return $this;
    }
    /**
     * Get listingStatus value
     * @return string|null
     */
    public function getListingStatus()
    {
        return $this->listingStatus;
    }
    /**
     * Set listingStatus value
     * @param string $listingStatus
     * @return \StructType\ProductServiceRetailResponse
     */
    public function setListingStatus($listingStatus = null)
    {
        // validation for constraint: string
        if (!is_null($listingStatus) && !is_string($listingStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($listingStatus, true), gettype($listingStatus)), __LINE__);
        }
        $this->listingStatus = $listingStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductServiceRetailResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
