<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productServiceListResponse StructType
 * @subpackage Structs
 */
class ProductServiceListResponse extends BaseResponse
{
    /**
     * The productCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $productCount;
    /**
     * The products
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Products
     */
    public $products;
    /**
     * Constructor method for productServiceListResponse
     * @uses ProductServiceListResponse::setProductCount()
     * @uses ProductServiceListResponse::setProducts()
     * @param int $productCount
     * @param \StructType\Products $products
     */
    public function __construct($productCount = null, \StructType\Products $products = null)
    {
        $this
            ->setProductCount($productCount)
            ->setProducts($products);
    }
    /**
     * Get productCount value
     * @return int|null
     */
    public function getProductCount()
    {
        return $this->productCount;
    }
    /**
     * Set productCount value
     * @param int $productCount
     * @return \StructType\ProductServiceListResponse
     */
    public function setProductCount($productCount = null)
    {
        // validation for constraint: int
        if (!is_null($productCount) && !(is_int($productCount) || ctype_digit($productCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productCount, true), gettype($productCount)), __LINE__);
        }
        $this->productCount = $productCount;
        return $this;
    }
    /**
     * Get products value
     * @return \StructType\Products|null
     */
    public function getProducts()
    {
        return $this->products;
    }
    /**
     * Set products value
     * @param \StructType\Products $products
     * @return \StructType\ProductServiceListResponse
     */
    public function setProducts(\StructType\Products $products = null)
    {
        $this->products = $products;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductServiceListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
