<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productServiceImageStatusResponse StructType
 * @subpackage Structs
 */
class ProductServiceImageStatusResponse extends BaseResponse
{
    /**
     * The productId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $productId;
    /**
     * The isDelayed
     * @var bool
     */
    public $isDelayed;
    /**
     * The photos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Photos
     */
    public $photos;
    /**
     * Constructor method for productServiceImageStatusResponse
     * @uses ProductServiceImageStatusResponse::setProductId()
     * @uses ProductServiceImageStatusResponse::setIsDelayed()
     * @uses ProductServiceImageStatusResponse::setPhotos()
     * @param string $productId
     * @param bool $isDelayed
     * @param \StructType\Photos $photos
     */
    public function __construct($productId = null, $isDelayed = null, \StructType\Photos $photos = null)
    {
        $this
            ->setProductId($productId)
            ->setIsDelayed($isDelayed)
            ->setPhotos($photos);
    }
    /**
     * Get productId value
     * @return string|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param string $productId
     * @return \StructType\ProductServiceImageStatusResponse
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get isDelayed value
     * @return bool|null
     */
    public function getIsDelayed()
    {
        return $this->isDelayed;
    }
    /**
     * Set isDelayed value
     * @param bool $isDelayed
     * @return \StructType\ProductServiceImageStatusResponse
     */
    public function setIsDelayed($isDelayed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDelayed) && !is_bool($isDelayed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDelayed, true), gettype($isDelayed)), __LINE__);
        }
        $this->isDelayed = $isDelayed;
        return $this;
    }
    /**
     * Get photos value
     * @return \StructType\Photos|null
     */
    public function getPhotos()
    {
        return $this->photos;
    }
    /**
     * Set photos value
     * @param \StructType\Photos $photos
     * @return \StructType\ProductServiceImageStatusResponse
     */
    public function setPhotos(\StructType\Photos $photos = null)
    {
        $this->photos = $photos;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductServiceImageStatusResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
