<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productIdList StructType
 * @subpackage Structs
 */
class ProductIdList extends AbstractStructBase
{
    /**
     * The productId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var int[]
     */
    public $productId;
    /**
     * Constructor method for productIdList
     * @uses ProductIdList::setProductId()
     * @param int[] $productId
     */
    public function __construct(array $productId = array())
    {
        $this
            ->setProductId($productId);
    }
    /**
     * Get productId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int[]|null
     */
    public function getProductId()
    {
        return isset($this->productId) ? $this->productId : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProductId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductIdForArrayConstraintsFromSetProductId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productIdListProductIdItem) {
            // validation for constraint: itemType
            if (!(is_int($productIdListProductIdItem) || ctype_digit($productIdListProductIdItem))) {
                $invalidValues[] = is_object($productIdListProductIdItem) ? get_class($productIdListProductIdItem) : sprintf('%s(%s)', gettype($productIdListProductIdItem), var_export($productIdListProductIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The productId property can only contain items of type int, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set productId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param int[] $productId
     * @return \StructType\ProductIdList
     */
    public function setProductId(array $productId = array())
    {
        // validation for constraint: array
        if ('' !== ($productIdArrayErrorMessage = self::validateProductIdForArrayConstraintsFromSetProductId($productId))) {
            throw new \InvalidArgumentException($productIdArrayErrorMessage, __LINE__);
        }
        if (is_null($productId) || (is_array($productId) && empty($productId))) {
            unset($this->productId);
        } else {
            $this->productId = $productId;
        }
        return $this;
    }
    /**
     * Add item to productId value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\ProductIdList
     */
    public function addToProductId($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The productId property can only contain items of type int, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->productId[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductIdList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
