<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productFailProcessType StructType
 * @subpackage Structs
 */
class ProductFailProcessType extends AbstractStructBase
{
    /**
     * The productId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $productId;
    /**
     * The failCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $failCode;
    /**
     * The failReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $failReason;
    /**
     * Constructor method for productFailProcessType
     * @uses ProductFailProcessType::setProductId()
     * @uses ProductFailProcessType::setFailCode()
     * @uses ProductFailProcessType::setFailReason()
     * @param int $productId
     * @param int $failCode
     * @param string $failReason
     */
    public function __construct($productId = null, $failCode = null, $failReason = null)
    {
        $this
            ->setProductId($productId)
            ->setFailCode($failCode)
            ->setFailReason($failReason);
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\ProductFailProcessType
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get failCode value
     * @return int|null
     */
    public function getFailCode()
    {
        return $this->failCode;
    }
    /**
     * Set failCode value
     * @param int $failCode
     * @return \StructType\ProductFailProcessType
     */
    public function setFailCode($failCode = null)
    {
        // validation for constraint: int
        if (!is_null($failCode) && !(is_int($failCode) || ctype_digit($failCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($failCode, true), gettype($failCode)), __LINE__);
        }
        $this->failCode = $failCode;
        return $this;
    }
    /**
     * Get failReason value
     * @return string|null
     */
    public function getFailReason()
    {
        return $this->failReason;
    }
    /**
     * Set failReason value
     * @param string $failReason
     * @return \StructType\ProductFailProcessType
     */
    public function setFailReason($failReason = null)
    {
        // validation for constraint: string
        if (!is_null($failReason) && !is_string($failReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($failReason, true), gettype($failReason)), __LINE__);
        }
        $this->failReason = $failReason;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductFailProcessType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
