<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Calculate ServiceType
 * @subpackage Services
 */
class Calculate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named calculatePriceForRevision
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $productId
     * @param string $itemId
     * @param string $lang
     * @return \StructType\ProductServicePriceResponse|bool
     */
    public function calculatePriceForRevision($apiKey, $sign, $time, $productId, $itemId, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->calculatePriceForRevision($apiKey, $sign, $time, $productId, $itemId, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named calculatePriceForShoppingCart
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param \ArrayType\IntArray $productIdList
     * @param \ArrayType\StringArray $itemIdList
     * @param string $lang
     * @return \StructType\ProductServicePriceResponse|bool
     */
    public function calculatePriceForShoppingCart($apiKey, $sign, $time, \ArrayType\IntArray $productIdList, \ArrayType\StringArray $itemIdList, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->calculatePriceForShoppingCart($apiKey, $sign, $time, $productIdList, $itemIdList, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ProductServicePriceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
