<?php

namespace EnumType;

/**
 * This class stands for itemIdDetailStatus EnumType
 * @subpackage Enumerations
 */
class ItemIdDetailStatus
{
    /**
     * Constant for value 'PASSIVE'
     * @return string 'PASSIVE'
     */
    const VALUE_PASSIVE = 'PASSIVE';
    /**
     * Constant for value 'ACTIVE'
     * @return string 'ACTIVE'
     */
    const VALUE_ACTIVE = 'ACTIVE';
    /**
     * Constant for value 'DUPLICATE_RECORD'
     * @return string 'DUPLICATE_RECORD'
     */
    const VALUE_DUPLICATE_RECORD = 'DUPLICATE_RECORD';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PASSIVE
     * @uses self::VALUE_ACTIVE
     * @uses self::VALUE_DUPLICATE_RECORD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PASSIVE,
            self::VALUE_ACTIVE,
            self::VALUE_DUPLICATE_RECORD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
