<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for variants StructType
 * @subpackage Structs
 */
class Variants extends AbstractStructBase
{
    /**
     * The variant
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VariantType[]
     */
    public $variant;
    /**
     * Constructor method for variants
     * @uses Variants::setVariant()
     * @param \StructType\VariantType[] $variant
     */
    public function __construct(array $variant = array())
    {
        $this
            ->setVariant($variant);
    }
    /**
     * Get variant value
     * @return \StructType\VariantType[]|null
     */
    public function getVariant()
    {
        return $this->variant;
    }
    /**
     * This method is responsible for validating the values passed to the setVariant method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVariant method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVariantForArrayConstraintsFromSetVariant(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $variantsVariantItem) {
            // validation for constraint: itemType
            if (!$variantsVariantItem instanceof \StructType\VariantType) {
                $invalidValues[] = is_object($variantsVariantItem) ? get_class($variantsVariantItem) : sprintf('%s(%s)', gettype($variantsVariantItem), var_export($variantsVariantItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The variant property can only contain items of type \StructType\VariantType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set variant value
     * @throws \InvalidArgumentException
     * @param \StructType\VariantType[] $variant
     * @return \StructType\Variants
     */
    public function setVariant(array $variant = array())
    {
        // validation for constraint: array
        if ('' !== ($variantArrayErrorMessage = self::validateVariantForArrayConstraintsFromSetVariant($variant))) {
            throw new \InvalidArgumentException($variantArrayErrorMessage, __LINE__);
        }
        $this->variant = $variant;
        return $this;
    }
    /**
     * Add item to variant value
     * @throws \InvalidArgumentException
     * @param \StructType\VariantType $item
     * @return \StructType\Variants
     */
    public function addToVariant(\StructType\VariantType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VariantType) {
            throw new \InvalidArgumentException(sprintf('The variant property can only contain items of type \StructType\VariantType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->variant[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Variants
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
