<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for variantSpecType StructType
 * @subpackage Structs
 */
class VariantSpecType extends AbstractStructBase
{
    /**
     * The nameId
     * @var int
     */
    public $nameId;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The valueId
     * @var int
     */
    public $valueId;
    /**
     * The value
     * @var string
     */
    public $value;
    /**
     * The orderNumber
     * @var int
     */
    public $orderNumber;
    /**
     * The specDataOrderNumber
     * @var int
     */
    public $specDataOrderNumber;
    /**
     * Constructor method for variantSpecType
     * @uses VariantSpecType::setNameId()
     * @uses VariantSpecType::setName()
     * @uses VariantSpecType::setValueId()
     * @uses VariantSpecType::setValue()
     * @uses VariantSpecType::setOrderNumber()
     * @uses VariantSpecType::setSpecDataOrderNumber()
     * @param int $nameId
     * @param string $name
     * @param int $valueId
     * @param string $value
     * @param int $orderNumber
     * @param int $specDataOrderNumber
     */
    public function __construct($nameId = null, $name = null, $valueId = null, $value = null, $orderNumber = null, $specDataOrderNumber = null)
    {
        $this
            ->setNameId($nameId)
            ->setName($name)
            ->setValueId($valueId)
            ->setValue($value)
            ->setOrderNumber($orderNumber)
            ->setSpecDataOrderNumber($specDataOrderNumber);
    }
    /**
     * Get nameId value
     * @return int|null
     */
    public function getNameId()
    {
        return $this->nameId;
    }
    /**
     * Set nameId value
     * @param int $nameId
     * @return \StructType\VariantSpecType
     */
    public function setNameId($nameId = null)
    {
        // validation for constraint: int
        if (!is_null($nameId) && !(is_int($nameId) || ctype_digit($nameId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nameId, true), gettype($nameId)), __LINE__);
        }
        $this->nameId = $nameId;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\VariantSpecType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get valueId value
     * @return int|null
     */
    public function getValueId()
    {
        return $this->valueId;
    }
    /**
     * Set valueId value
     * @param int $valueId
     * @return \StructType\VariantSpecType
     */
    public function setValueId($valueId = null)
    {
        // validation for constraint: int
        if (!is_null($valueId) && !(is_int($valueId) || ctype_digit($valueId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($valueId, true), gettype($valueId)), __LINE__);
        }
        $this->valueId = $valueId;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\VariantSpecType
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get orderNumber value
     * @return int|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param int $orderNumber
     * @return \StructType\VariantSpecType
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: int
        if (!is_null($orderNumber) && !(is_int($orderNumber) || ctype_digit($orderNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get specDataOrderNumber value
     * @return int|null
     */
    public function getSpecDataOrderNumber()
    {
        return $this->specDataOrderNumber;
    }
    /**
     * Set specDataOrderNumber value
     * @param int $specDataOrderNumber
     * @return \StructType\VariantSpecType
     */
    public function setSpecDataOrderNumber($specDataOrderNumber = null)
    {
        // validation for constraint: int
        if (!is_null($specDataOrderNumber) && !(is_int($specDataOrderNumber) || ctype_digit($specDataOrderNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($specDataOrderNumber, true), gettype($specDataOrderNumber)), __LINE__);
        }
        $this->specDataOrderNumber = $specDataOrderNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VariantSpecType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
