<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sameDayDeliveryType StructType
 * @subpackage Structs
 */
class SameDayDeliveryType extends AbstractStructBase
{
    /**
     * The lastReceivingTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastReceivingTime;
    /**
     * The shippingId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $shippingId;
    /**
     * Constructor method for sameDayDeliveryType
     * @uses SameDayDeliveryType::setLastReceivingTime()
     * @uses SameDayDeliveryType::setShippingId()
     * @param string $lastReceivingTime
     * @param int $shippingId
     */
    public function __construct($lastReceivingTime = null, $shippingId = null)
    {
        $this
            ->setLastReceivingTime($lastReceivingTime)
            ->setShippingId($shippingId);
    }
    /**
     * Get lastReceivingTime value
     * @return string|null
     */
    public function getLastReceivingTime()
    {
        return $this->lastReceivingTime;
    }
    /**
     * Set lastReceivingTime value
     * @param string $lastReceivingTime
     * @return \StructType\SameDayDeliveryType
     */
    public function setLastReceivingTime($lastReceivingTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastReceivingTime) && !is_string($lastReceivingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastReceivingTime, true), gettype($lastReceivingTime)), __LINE__);
        }
        $this->lastReceivingTime = $lastReceivingTime;
        return $this;
    }
    /**
     * Get shippingId value
     * @return int|null
     */
    public function getShippingId()
    {
        return $this->shippingId;
    }
    /**
     * Set shippingId value
     * @param int $shippingId
     * @return \StructType\SameDayDeliveryType
     */
    public function setShippingId($shippingId = null)
    {
        // validation for constraint: int
        if (!is_null($shippingId) && !(is_int($shippingId) || ctype_digit($shippingId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shippingId, true), gettype($shippingId)), __LINE__);
        }
        $this->shippingId = $shippingId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SameDayDeliveryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
