<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productStatusList StructType
 * @subpackage Structs
 */
class ProductStatusList extends AbstractStructBase
{
    /**
     * The productStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProductStatusType[]
     */
    public $productStatus;
    /**
     * Constructor method for productStatusList
     * @uses ProductStatusList::setProductStatus()
     * @param \StructType\ProductStatusType[] $productStatus
     */
    public function __construct(array $productStatus = array())
    {
        $this
            ->setProductStatus($productStatus);
    }
    /**
     * Get productStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProductStatusType[]|null
     */
    public function getProductStatus()
    {
        return isset($this->productStatus) ? $this->productStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProductStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProductStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductStatusForArrayConstraintsFromSetProductStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productStatusListProductStatusItem) {
            // validation for constraint: itemType
            if (!$productStatusListProductStatusItem instanceof \StructType\ProductStatusType) {
                $invalidValues[] = is_object($productStatusListProductStatusItem) ? get_class($productStatusListProductStatusItem) : sprintf('%s(%s)', gettype($productStatusListProductStatusItem), var_export($productStatusListProductStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The productStatus property can only contain items of type \StructType\ProductStatusType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set productStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProductStatusType[] $productStatus
     * @return \StructType\ProductStatusList
     */
    public function setProductStatus(array $productStatus = array())
    {
        // validation for constraint: array
        if ('' !== ($productStatusArrayErrorMessage = self::validateProductStatusForArrayConstraintsFromSetProductStatus($productStatus))) {
            throw new \InvalidArgumentException($productStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($productStatus) || (is_array($productStatus) && empty($productStatus))) {
            unset($this->productStatus);
        } else {
            $this->productStatus = $productStatus;
        }
        return $this;
    }
    /**
     * Add item to productStatus value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductStatusType $item
     * @return \StructType\ProductStatusList
     */
    public function addToProductStatus(\StructType\ProductStatusType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductStatusType) {
            throw new \InvalidArgumentException(sprintf('The productStatus property can only contain items of type \StructType\ProductStatusType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->productStatus[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductStatusList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
