<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productServiceSpecResponse StructType
 * @subpackage Structs
 */
class ProductServiceSpecResponse extends BaseResponse
{
    /**
     * The productId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $productId;
    /**
     * The itemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemId;
    /**
     * The specs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Specs
     */
    public $specs;
    /**
     * Constructor method for productServiceSpecResponse
     * @uses ProductServiceSpecResponse::setProductId()
     * @uses ProductServiceSpecResponse::setItemId()
     * @uses ProductServiceSpecResponse::setSpecs()
     * @param int $productId
     * @param string $itemId
     * @param \StructType\Specs $specs
     */
    public function __construct($productId = null, $itemId = null, \StructType\Specs $specs = null)
    {
        $this
            ->setProductId($productId)
            ->setItemId($itemId)
            ->setSpecs($specs);
    }
    /**
     * Get productId value
     * @return int|null
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\ProductServiceSpecResponse
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get itemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->itemId;
    }
    /**
     * Set itemId value
     * @param string $itemId
     * @return \StructType\ProductServiceSpecResponse
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->itemId = $itemId;
        return $this;
    }
    /**
     * Get specs value
     * @return \StructType\Specs|null
     */
    public function getSpecs()
    {
        return $this->specs;
    }
    /**
     * Set specs value
     * @param \StructType\Specs $specs
     * @return \StructType\ProductServiceSpecResponse
     */
    public function setSpecs(\StructType\Specs $specs = null)
    {
        $this->specs = $specs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductServiceSpecResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
