<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productServicePaymentResponse StructType
 * @subpackage Structs
 */
class ProductServicePaymentResponse extends BaseResponse
{
    /**
     * The paidPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paidPrice;
    /**
     * The productCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $productCount;
    /**
     * The products
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Products
     */
    public $products;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * Constructor method for productServicePaymentResponse
     * @uses ProductServicePaymentResponse::setPaidPrice()
     * @uses ProductServicePaymentResponse::setProductCount()
     * @uses ProductServicePaymentResponse::setProducts()
     * @uses ProductServicePaymentResponse::setMessage()
     * @param string $paidPrice
     * @param int $productCount
     * @param \StructType\Products $products
     * @param string $message
     */
    public function __construct($paidPrice = null, $productCount = null, \StructType\Products $products = null, $message = null)
    {
        $this
            ->setPaidPrice($paidPrice)
            ->setProductCount($productCount)
            ->setProducts($products)
            ->setMessage($message);
    }
    /**
     * Get paidPrice value
     * @return string|null
     */
    public function getPaidPrice()
    {
        return $this->paidPrice;
    }
    /**
     * Set paidPrice value
     * @param string $paidPrice
     * @return \StructType\ProductServicePaymentResponse
     */
    public function setPaidPrice($paidPrice = null)
    {
        // validation for constraint: string
        if (!is_null($paidPrice) && !is_string($paidPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paidPrice, true), gettype($paidPrice)), __LINE__);
        }
        $this->paidPrice = $paidPrice;
        return $this;
    }
    /**
     * Get productCount value
     * @return int|null
     */
    public function getProductCount()
    {
        return $this->productCount;
    }
    /**
     * Set productCount value
     * @param int $productCount
     * @return \StructType\ProductServicePaymentResponse
     */
    public function setProductCount($productCount = null)
    {
        // validation for constraint: int
        if (!is_null($productCount) && !(is_int($productCount) || ctype_digit($productCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productCount, true), gettype($productCount)), __LINE__);
        }
        $this->productCount = $productCount;
        return $this;
    }
    /**
     * Get products value
     * @return \StructType\Products|null
     */
    public function getProducts()
    {
        return $this->products;
    }
    /**
     * Set products value
     * @param \StructType\Products $products
     * @return \StructType\ProductServicePaymentResponse
     */
    public function setProducts(\StructType\Products $products = null)
    {
        $this->products = $products;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\ProductServicePaymentResponse
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductServicePaymentResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
