<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productPackageSizeType StructType
 * @subpackage Structs
 */
class ProductPackageSizeType extends AbstractStructBase
{
    /**
     * The width
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $width;
    /**
     * The height
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $height;
    /**
     * The depth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $depth;
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $weight;
    /**
     * The desi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $desi;
    /**
     * Constructor method for productPackageSizeType
     * @uses ProductPackageSizeType::setWidth()
     * @uses ProductPackageSizeType::setHeight()
     * @uses ProductPackageSizeType::setDepth()
     * @uses ProductPackageSizeType::setWeight()
     * @uses ProductPackageSizeType::setDesi()
     * @param int $width
     * @param int $height
     * @param int $depth
     * @param float $weight
     * @param float $desi
     */
    public function __construct($width = null, $height = null, $depth = null, $weight = null, $desi = null)
    {
        $this
            ->setWidth($width)
            ->setHeight($height)
            ->setDepth($depth)
            ->setWeight($weight)
            ->setDesi($desi);
    }
    /**
     * Get width value
     * @return int|null
     */
    public function getWidth()
    {
        return $this->width;
    }
    /**
     * Set width value
     * @param int $width
     * @return \StructType\ProductPackageSizeType
     */
    public function setWidth($width = null)
    {
        // validation for constraint: int
        if (!is_null($width) && !(is_int($width) || ctype_digit($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->width = $width;
        return $this;
    }
    /**
     * Get height value
     * @return int|null
     */
    public function getHeight()
    {
        return $this->height;
    }
    /**
     * Set height value
     * @param int $height
     * @return \StructType\ProductPackageSizeType
     */
    public function setHeight($height = null)
    {
        // validation for constraint: int
        if (!is_null($height) && !(is_int($height) || ctype_digit($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->height = $height;
        return $this;
    }
    /**
     * Get depth value
     * @return int|null
     */
    public function getDepth()
    {
        return $this->depth;
    }
    /**
     * Set depth value
     * @param int $depth
     * @return \StructType\ProductPackageSizeType
     */
    public function setDepth($depth = null)
    {
        // validation for constraint: int
        if (!is_null($depth) && !(is_int($depth) || ctype_digit($depth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($depth, true), gettype($depth)), __LINE__);
        }
        $this->depth = $depth;
        return $this;
    }
    /**
     * Get weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return \StructType\ProductPackageSizeType
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get desi value
     * @return float|null
     */
    public function getDesi()
    {
        return $this->desi;
    }
    /**
     * Set desi value
     * @param float $desi
     * @return \StructType\ProductPackageSizeType
     */
    public function setDesi($desi = null)
    {
        // validation for constraint: float
        if (!is_null($desi) && !(is_float($desi) || is_numeric($desi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($desi, true), gettype($desi)), __LINE__);
        }
        $this->desi = $desi;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductPackageSizeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
