<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productConcerningType StructType
 * @subpackage Structs
 */
class ProductConcerningType extends AbstractStructBase
{
    /**
     * The soldCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $soldCount;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The listingStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $listingStatus;
    /**
     * The currentPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currentPrice;
    /**
     * The hasRelistOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $hasRelistOption;
    /**
     * The bidCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $bidCount;
    /**
     * Constructor method for productConcerningType
     * @uses ProductConcerningType::setSoldCount()
     * @uses ProductConcerningType::setEndDate()
     * @uses ProductConcerningType::setListingStatus()
     * @uses ProductConcerningType::setCurrentPrice()
     * @uses ProductConcerningType::setHasRelistOption()
     * @uses ProductConcerningType::setBidCount()
     * @param int $soldCount
     * @param string $endDate
     * @param string $listingStatus
     * @param string $currentPrice
     * @param bool $hasRelistOption
     * @param int $bidCount
     */
    public function __construct($soldCount = null, $endDate = null, $listingStatus = null, $currentPrice = null, $hasRelistOption = null, $bidCount = null)
    {
        $this
            ->setSoldCount($soldCount)
            ->setEndDate($endDate)
            ->setListingStatus($listingStatus)
            ->setCurrentPrice($currentPrice)
            ->setHasRelistOption($hasRelistOption)
            ->setBidCount($bidCount);
    }
    /**
     * Get soldCount value
     * @return int|null
     */
    public function getSoldCount()
    {
        return $this->soldCount;
    }
    /**
     * Set soldCount value
     * @param int $soldCount
     * @return \StructType\ProductConcerningType
     */
    public function setSoldCount($soldCount = null)
    {
        // validation for constraint: int
        if (!is_null($soldCount) && !(is_int($soldCount) || ctype_digit($soldCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($soldCount, true), gettype($soldCount)), __LINE__);
        }
        $this->soldCount = $soldCount;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\ProductConcerningType
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get listingStatus value
     * @return string|null
     */
    public function getListingStatus()
    {
        return $this->listingStatus;
    }
    /**
     * Set listingStatus value
     * @param string $listingStatus
     * @return \StructType\ProductConcerningType
     */
    public function setListingStatus($listingStatus = null)
    {
        // validation for constraint: string
        if (!is_null($listingStatus) && !is_string($listingStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($listingStatus, true), gettype($listingStatus)), __LINE__);
        }
        $this->listingStatus = $listingStatus;
        return $this;
    }
    /**
     * Get currentPrice value
     * @return string|null
     */
    public function getCurrentPrice()
    {
        return $this->currentPrice;
    }
    /**
     * Set currentPrice value
     * @param string $currentPrice
     * @return \StructType\ProductConcerningType
     */
    public function setCurrentPrice($currentPrice = null)
    {
        // validation for constraint: string
        if (!is_null($currentPrice) && !is_string($currentPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentPrice, true), gettype($currentPrice)), __LINE__);
        }
        $this->currentPrice = $currentPrice;
        return $this;
    }
    /**
     * Get hasRelistOption value
     * @return bool|null
     */
    public function getHasRelistOption()
    {
        return $this->hasRelistOption;
    }
    /**
     * Set hasRelistOption value
     * @param bool $hasRelistOption
     * @return \StructType\ProductConcerningType
     */
    public function setHasRelistOption($hasRelistOption = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasRelistOption) && !is_bool($hasRelistOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasRelistOption, true), gettype($hasRelistOption)), __LINE__);
        }
        $this->hasRelistOption = $hasRelistOption;
        return $this;
    }
    /**
     * Get bidCount value
     * @return int|null
     */
    public function getBidCount()
    {
        return $this->bidCount;
    }
    /**
     * Set bidCount value
     * @param int $bidCount
     * @return \StructType\ProductConcerningType
     */
    public function setBidCount($bidCount = null)
    {
        // validation for constraint: int
        if (!is_null($bidCount) && !(is_int($bidCount) || ctype_digit($bidCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bidCount, true), gettype($bidCount)), __LINE__);
        }
        $this->bidCount = $bidCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductConcerningType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
