<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for photoType StructType
 * @subpackage Structs
 */
class PhotoType extends AbstractStructBase
{
    /**
     * The url
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $url;
    /**
     * The base64
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $base64;
    /**
     * The photoId
     * @var int
     */
    public $photoId;
    /**
     * Constructor method for photoType
     * @uses PhotoType::setUrl()
     * @uses PhotoType::setBase64()
     * @uses PhotoType::setPhotoId()
     * @param string $url
     * @param string $base64
     * @param int $photoId
     */
    public function __construct($url = null, $base64 = null, $photoId = null)
    {
        $this
            ->setUrl($url)
            ->setBase64($base64)
            ->setPhotoId($photoId);
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \StructType\PhotoType
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get base64 value
     * @return string|null
     */
    public function getBase64()
    {
        return $this->base64;
    }
    /**
     * Set base64 value
     * @param string $base64
     * @return \StructType\PhotoType
     */
    public function setBase64($base64 = null)
    {
        // validation for constraint: string
        if (!is_null($base64) && !is_string($base64)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($base64, true), gettype($base64)), __LINE__);
        }
        $this->base64 = $base64;
        return $this;
    }
    /**
     * Get photoId value
     * @return int|null
     */
    public function getPhotoId()
    {
        return $this->photoId;
    }
    /**
     * Set photoId value
     * @param int $photoId
     * @return \StructType\PhotoType
     */
    public function setPhotoId($photoId = null)
    {
        // validation for constraint: int
        if (!is_null($photoId) && !(is_int($photoId) || ctype_digit($photoId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($photoId, true), gettype($photoId)), __LINE__);
        }
        $this->photoId = $photoId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PhotoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
