<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for itemIdDetails StructType
 * @subpackage Structs
 */
class ItemIdDetails extends AbstractStructBase
{
    /**
     * The itemIdDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ItemIdDetailType[]
     */
    public $itemIdDetail;
    /**
     * Constructor method for itemIdDetails
     * @uses ItemIdDetails::setItemIdDetail()
     * @param \StructType\ItemIdDetailType[] $itemIdDetail
     */
    public function __construct(array $itemIdDetail = array())
    {
        $this
            ->setItemIdDetail($itemIdDetail);
    }
    /**
     * Get itemIdDetail value
     * @return \StructType\ItemIdDetailType[]|null
     */
    public function getItemIdDetail()
    {
        return $this->itemIdDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setItemIdDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemIdDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemIdDetailForArrayConstraintsFromSetItemIdDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemIdDetailsItemIdDetailItem) {
            // validation for constraint: itemType
            if (!$itemIdDetailsItemIdDetailItem instanceof \StructType\ItemIdDetailType) {
                $invalidValues[] = is_object($itemIdDetailsItemIdDetailItem) ? get_class($itemIdDetailsItemIdDetailItem) : sprintf('%s(%s)', gettype($itemIdDetailsItemIdDetailItem), var_export($itemIdDetailsItemIdDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The itemIdDetail property can only contain items of type \StructType\ItemIdDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set itemIdDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemIdDetailType[] $itemIdDetail
     * @return \StructType\ItemIdDetails
     */
    public function setItemIdDetail(array $itemIdDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($itemIdDetailArrayErrorMessage = self::validateItemIdDetailForArrayConstraintsFromSetItemIdDetail($itemIdDetail))) {
            throw new \InvalidArgumentException($itemIdDetailArrayErrorMessage, __LINE__);
        }
        $this->itemIdDetail = $itemIdDetail;
        return $this;
    }
    /**
     * Add item to itemIdDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemIdDetailType $item
     * @return \StructType\ItemIdDetails
     */
    public function addToItemIdDetail(\StructType\ItemIdDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemIdDetailType) {
            throw new \InvalidArgumentException(sprintf('The itemIdDetail property can only contain items of type \StructType\ItemIdDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->itemIdDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemIdDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
