<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for failedProcesses StructType
 * @subpackage Structs
 */
class FailedProcesses extends AbstractStructBase
{
    /**
     * The failedProcess
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProductFailProcessType[]
     */
    public $failedProcess;
    /**
     * Constructor method for failedProcesses
     * @uses FailedProcesses::setFailedProcess()
     * @param \StructType\ProductFailProcessType[] $failedProcess
     */
    public function __construct(array $failedProcess = array())
    {
        $this
            ->setFailedProcess($failedProcess);
    }
    /**
     * Get failedProcess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProductFailProcessType[]|null
     */
    public function getFailedProcess()
    {
        return isset($this->failedProcess) ? $this->failedProcess : null;
    }
    /**
     * This method is responsible for validating the values passed to the setFailedProcess method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFailedProcess method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFailedProcessForArrayConstraintsFromSetFailedProcess(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $failedProcessesFailedProcessItem) {
            // validation for constraint: itemType
            if (!$failedProcessesFailedProcessItem instanceof \StructType\ProductFailProcessType) {
                $invalidValues[] = is_object($failedProcessesFailedProcessItem) ? get_class($failedProcessesFailedProcessItem) : sprintf('%s(%s)', gettype($failedProcessesFailedProcessItem), var_export($failedProcessesFailedProcessItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The failedProcess property can only contain items of type \StructType\ProductFailProcessType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set failedProcess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProductFailProcessType[] $failedProcess
     * @return \StructType\FailedProcesses
     */
    public function setFailedProcess(array $failedProcess = array())
    {
        // validation for constraint: array
        if ('' !== ($failedProcessArrayErrorMessage = self::validateFailedProcessForArrayConstraintsFromSetFailedProcess($failedProcess))) {
            throw new \InvalidArgumentException($failedProcessArrayErrorMessage, __LINE__);
        }
        if (is_null($failedProcess) || (is_array($failedProcess) && empty($failedProcess))) {
            unset($this->failedProcess);
        } else {
            $this->failedProcess = $failedProcess;
        }
        return $this;
    }
    /**
     * Add item to failedProcess value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductFailProcessType $item
     * @return \StructType\FailedProcesses
     */
    public function addToFailedProcess(\StructType\ProductFailProcessType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductFailProcessType) {
            throw new \InvalidArgumentException(sprintf('The failedProcess property can only contain items of type \StructType\ProductFailProcessType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->failedProcess[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FailedProcesses
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
