<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Clone ServiceType
 * @subpackage Services
 */
class _Clone extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named cloneProduct
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $productId
     * @param string $itemId
     * @param string $lang
     * @return \StructType\ProductServiceResponse|bool
     */
    public function cloneProduct($apiKey, $sign, $time, $productId, $itemId, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->cloneProduct($apiKey, $sign, $time, $productId, $itemId, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ProductServiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
