<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named updateItemId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $productId
     * @param string $itemId
     * @param string $lang
     * @return \StructType\ProductServiceResponse|bool
     */
    public function updateItemId($apiKey, $sign, $time, $productId, $itemId, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->updateItemId($apiKey, $sign, $time, $productId, $itemId, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMarketPrice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $productId
     * @param string $marketPrice
     * @param string $lang
     * @return \StructType\ProductServiceResponse|bool
     */
    public function updateMarketPrice($apiKey, $sign, $time, $productId, $marketPrice, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->updateMarketPrice($apiKey, $sign, $time, $productId, $marketPrice, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePrice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $productId
     * @param string $itemId
     * @param string $price
     * @param string $cancelBid
     * @param string $lang
     * @return \StructType\ProductServiceResponse|bool
     */
    public function updatePrice($apiKey, $sign, $time, $productId, $itemId, $price, $cancelBid, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->updatePrice($apiKey, $sign, $time, $productId, $itemId, $price, $cancelBid, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePriceByPercentage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $productId
     * @param string $itemId
     * @param string $operatorType
     * @param string $percentage
     * @param string $lang
     * @return \StructType\ProductServiceResponse|bool
     */
    public function updatePriceByPercentage($apiKey, $sign, $time, $productId, $itemId, $operatorType, $percentage, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->updatePriceByPercentage($apiKey, $sign, $time, $productId, $itemId, $operatorType, $percentage, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateProduct
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $itemId
     * @param string $productId
     * @param \StructType\ProductType $product
     * @param string $onSale
     * @param string $forceToSpecEntry
     * @param string $nextDateOption
     * @param string $lang
     * @return \StructType\ProductServiceResponse|bool
     */
    public function updateProduct($apiKey, $sign, $time, $itemId, $productId, \StructType\ProductType $product, $onSale, $forceToSpecEntry, $nextDateOption, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->updateProduct($apiKey, $sign, $time, $itemId, $productId, $product, $onSale, $forceToSpecEntry, $nextDateOption, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateProductVariants
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $productId
     * @param string $itemId
     * @param \StructType\ProductVariantType $productVariant
     * @param string $lang
     * @return \StructType\ProductServiceRetailResponse|bool
     */
    public function updateProductVariants($apiKey, $sign, $time, $productId, $itemId, \StructType\ProductVariantType $productVariant, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->updateProductVariants($apiKey, $sign, $time, $productId, $itemId, $productVariant, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateProductWithNewCargoDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $itemId
     * @param string $productId
     * @param \StructType\ProductType $product
     * @param string $onSale
     * @param string $forceToSpecEntry
     * @param string $nextDateOption
     * @param string $lang
     * @return \StructType\ProductServiceResponse|bool
     */
    public function updateProductWithNewCargoDetail($apiKey, $sign, $time, $itemId, $productId, \StructType\ProductType $product, $onSale, $forceToSpecEntry, $nextDateOption, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->updateProductWithNewCargoDetail($apiKey, $sign, $time, $itemId, $productId, $product, $onSale, $forceToSpecEntry, $nextDateOption, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateProductWithVariants
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $itemId
     * @param string $productId
     * @param \StructType\ProductType $product
     * @param string $onSale
     * @param string $forceToSpecEntry
     * @param string $nextDateOption
     * @param string $lang
     * @return \StructType\ProductServiceResponse|bool
     */
    public function updateProductWithVariants($apiKey, $sign, $time, $itemId, $productId, \StructType\ProductType $product, $onSale, $forceToSpecEntry, $nextDateOption, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->updateProductWithVariants($apiKey, $sign, $time, $itemId, $productId, $product, $onSale, $forceToSpecEntry, $nextDateOption, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateStock
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $productId
     * @param string $itemId
     * @param string $stock
     * @param string $cancelBid
     * @param string $lang
     * @return \StructType\ProductServiceResponse|bool
     */
    public function updateStock($apiKey, $sign, $time, $productId, $itemId, $stock, $cancelBid, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->updateStock($apiKey, $sign, $time, $productId, $itemId, $stock, $cancelBid, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateVariantStock
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $productId
     * @param string $itemId
     * @param string $variantId
     * @param string $stock
     * @param string $lang
     * @return \StructType\ProductServiceResponse|bool
     */
    public function updateVariantStock($apiKey, $sign, $time, $productId, $itemId, $variantId, $stock, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->updateVariantStock($apiKey, $sign, $time, $productId, $itemId, $variantId, $stock, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ProductServiceResponse|\StructType\ProductServiceRetailResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
