<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Pay ServiceType
 * @subpackage Services
 */
class Pay extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named payPrice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $voucher
     * @param string $ccOwnerName
     * @param string $ccOwnerSurname
     * @param string $ccNumber
     * @param string $cvv
     * @param string $expireMonth
     * @param string $expireYear
     * @param string $lang
     * @return \StructType\ProductServicePaymentResponse|bool
     */
    public function payPrice($apiKey, $sign, $time, $voucher, $ccOwnerName, $ccOwnerSurname, $ccNumber, $cvv, $expireMonth, $expireYear, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->payPrice($apiKey, $sign, $time, $voucher, $ccOwnerName, $ccOwnerSurname, $ccNumber, $cvv, $expireMonth, $expireYear, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ProductServicePaymentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
