<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getItemIdDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param \ArrayType\IntArray $productIds
     * @param string $lang
     * @return \StructType\ItemIdDetailResponse|bool
     */
    public function getItemIdDetails($apiKey, $sign, $time, \ArrayType\IntArray $productIds, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->getItemIdDetails($apiKey, $sign, $time, $productIds, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNewlyListedProductIdList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $startOffSet
     * @param string $rowCount
     * @param string $viaApi
     * @param string $lang
     * @return \StructType\ProductServiceIdResponse|bool
     */
    public function getNewlyListedProductIdList($apiKey, $sign, $time, $startOffSet, $rowCount, $viaApi, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->getNewlyListedProductIdList($apiKey, $sign, $time, $startOffSet, $rowCount, $viaApi, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProduct
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $productId
     * @param string $itemId
     * @param string $lang
     * @return \StructType\ProductServiceDetailResponse|bool
     */
    public function getProduct($apiKey, $sign, $time, $productId, $itemId, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->getProduct($apiKey, $sign, $time, $productId, $itemId, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductDescription
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $productId
     * @param string $itemId
     * @param string $lang
     * @return \StructType\ProductServiceDescResponse|bool
     */
    public function getProductDescription($apiKey, $sign, $time, $productId, $itemId, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->getProductDescription($apiKey, $sign, $time, $productId, $itemId, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getProductFinishReasonListByAuthenticatedUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $startOffSet
     * @param string $rowCount
     * @param string $lang
     * @return \StructType\ProductFinishReasonListResponse|bool
     */
    public function getProductFinishReasonListByAuthenticatedUser($apiKey, $sign, $time, $startOffSet, $rowCount, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->getProductFinishReasonListByAuthenticatedUser($apiKey, $sign, $time, $startOffSet, $rowCount, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductIds
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $startOffSet
     * @param string $rowCount
     * @param \ArrayType\StringArray $statusTypes
     * @param string $lang
     * @return \StructType\ProductServiceIdResponse|bool
     */
    public function getProductIds($apiKey, $sign, $time, $startOffSet, $rowCount, \ArrayType\StringArray $statusTypes, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->getProductIds($apiKey, $sign, $time, $startOffSet, $rowCount, $statusTypes, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductImageStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $productId
     * @param string $lang
     * @return \StructType\ProductServiceImageStatusResponse|bool
     */
    public function getProductImageStatus($apiKey, $sign, $time, $productId, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->getProductImageStatus($apiKey, $sign, $time, $productId, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductSpecs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $productId
     * @param string $itemId
     * @param string $lang
     * @return \StructType\ProductServiceSpecResponse|bool
     */
    public function getProductSpecs($apiKey, $sign, $time, $productId, $itemId, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->getProductSpecs($apiKey, $sign, $time, $productId, $itemId, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductStatuses
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param \ArrayType\IntArray $productIdList
     * @param \ArrayType\StringArray $itemIdList
     * @param string $lang
     * @return \StructType\ProductServiceStatusResponse|bool
     */
    public function getProductStatuses($apiKey, $sign, $time, \ArrayType\IntArray $productIdList, \ArrayType\StringArray $itemIdList, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->getProductStatuses($apiKey, $sign, $time, $productIdList, $itemIdList, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductVariants
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $productId
     * @param string $itemId
     * @param string $variantId
     * @param string $variantStockCode
     * @param string $lang
     * @return \StructType\ProductServiceVariantResponse|bool
     */
    public function getProductVariants($apiKey, $sign, $time, $productId, $itemId, $variantId, $variantStockCode, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->getProductVariants($apiKey, $sign, $time, $productId, $itemId, $variantId, $variantStockCode, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProducts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $startOffSet
     * @param string $rowCount
     * @param string $status
     * @param string $withData
     * @param string $lang
     * @return \StructType\ProductServiceListResponse|bool
     */
    public function getProducts($apiKey, $sign, $time, $startOffSet, $rowCount, $status, $withData, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->getProducts($apiKey, $sign, $time, $startOffSet, $rowCount, $status, $withData, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProductsByIds
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param \ArrayType\IntArray $productIdList
     * @param \ArrayType\StringArray $itemIdList
     * @param string $withData
     * @param string $lang
     * @return \StructType\ProductServiceListResponse|bool
     */
    public function getProductsByIds($apiKey, $sign, $time, \ArrayType\IntArray $productIdList, \ArrayType\StringArray $itemIdList, $withData, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->getProductsByIds($apiKey, $sign, $time, $productIdList, $itemIdList, $withData, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getServiceName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return string|bool
     */
    public function getServiceName()
    {
        try {
            $this->setResult($this->getSoapClient()->getServiceName());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStockAndPrice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param \ArrayType\IntArray $productIdList
     * @param \ArrayType\StringArray $itemIdList
     * @param string $lang
     * @return \StructType\ProductServiceStockResponse|bool
     */
    public function getStockAndPrice($apiKey, $sign, $time, \ArrayType\IntArray $productIdList, \ArrayType\StringArray $itemIdList, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->getStockAndPrice($apiKey, $sign, $time, $productIdList, $itemIdList, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string|\StructType\ItemIdDetailResponse|\StructType\ProductFinishReasonListResponse|\StructType\ProductServiceDescResponse|\StructType\ProductServiceDetailResponse|\StructType\ProductServiceIdResponse|\StructType\ProductServiceImageStatusResponse|\StructType\ProductServiceListResponse|\StructType\ProductServiceSpecResponse|\StructType\ProductServiceStatusResponse|\StructType\ProductServiceStockResponse|\StructType\ProductServiceVariantResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
