<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named deleteProduct
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param \ArrayType\IntArray $productIdList
     * @param \ArrayType\StringArray $itemIdList
     * @param string $lang
     * @return \StructType\ProductServiceIdResponse|bool
     */
    public function deleteProduct($apiKey, $sign, $time, \ArrayType\IntArray $productIdList, \ArrayType\StringArray $itemIdList, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteProduct($apiKey, $sign, $time, $productIdList, $itemIdList, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteProducts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param \ArrayType\IntArray $productIdList
     * @param \ArrayType\StringArray $itemIdList
     * @param string $lang
     * @return \StructType\ProductServiceProcessResponse|bool
     */
    public function deleteProducts($apiKey, $sign, $time, \ArrayType\IntArray $productIdList, \ArrayType\StringArray $itemIdList, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteProducts($apiKey, $sign, $time, $productIdList, $itemIdList, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ProductServiceIdResponse|\StructType\ProductServiceProcessResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
