<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'intArray' => '\\ArrayType\\IntArray',
            'stringArray' => '\\ArrayType\\StringArray',
            'productType' => '\\StructType\\ProductType',
            'specs' => '\\StructType\\Specs',
            'photos' => '\\StructType\\Photos',
            'variantGroups' => '\\StructType\\VariantGroups',
            'sameDayDeliveryTypes' => '\\StructType\\SameDayDeliveryTypes',
            'specType' => '\\StructType\\SpecType',
            'photoType' => '\\StructType\\PhotoType',
            'cargoDetailType' => '\\StructType\\CargoDetailType',
            'cargoCompanies' => '\\StructType\\CargoCompanies',
            'cargoCompanyDetails' => '\\StructType\\CargoCompanyDetails',
            'cargoCompanyDetailType' => '\\StructType\\CargoCompanyDetailType',
            'cargoTimeType' => '\\StructType\\CargoTimeType',
            'productPackageSizeType' => '\\StructType\\ProductPackageSizeType',
            'variantGroupType' => '\\StructType\\VariantGroupType',
            'variants' => '\\StructType\\Variants',
            'variantType' => '\\StructType\\VariantType',
            'variantSpecs' => '\\StructType\\VariantSpecs',
            'variantSpecType' => '\\StructType\\VariantSpecType',
            'sameDayDeliveryType' => '\\StructType\\SameDayDeliveryType',
            'productServiceResponse' => '\\StructType\\ProductServiceResponse',
            'baseResponse' => '\\StructType\\BaseResponse',
            'errorType' => '\\StructType\\ErrorType',
            'productServiceIdResponse' => '\\StructType\\ProductServiceIdResponse',
            'productIdList' => '\\StructType\\ProductIdList',
            'productServicePaymentResponse' => '\\StructType\\ProductServicePaymentResponse',
            'products' => '\\StructType\\Products',
            'productServiceListResponse' => '\\StructType\\ProductServiceListResponse',
            'productDetailType' => '\\StructType\\ProductDetailType',
            'productConcerningType' => '\\StructType\\ProductConcerningType',
            'productServiceStockResponse' => '\\StructType\\ProductServiceStockResponse',
            'stockDetailType' => '\\StructType\\StockDetailType',
            'productServiceDescResponse' => '\\StructType\\ProductServiceDescResponse',
            'productServiceSpecResponse' => '\\StructType\\ProductServiceSpecResponse',
            'productServiceStatusResponse' => '\\StructType\\ProductServiceStatusResponse',
            'productStatusList' => '\\StructType\\ProductStatusList',
            'productStatusType' => '\\StructType\\ProductStatusType',
            'productServiceImageStatusResponse' => '\\StructType\\ProductServiceImageStatusResponse',
            'imageLogValueType' => '\\StructType\\ImageLogValueType',
            'productServiceProcessResponse' => '\\StructType\\ProductServiceProcessResponse',
            'successfulProcesses' => '\\StructType\\SuccessfulProcesses',
            'failedProcesses' => '\\StructType\\FailedProcesses',
            'productSuccessProcessType' => '\\StructType\\ProductSuccessProcessType',
            'productFailProcessType' => '\\StructType\\ProductFailProcessType',
            'productServicePriceResponse' => '\\StructType\\ProductServicePriceResponse',
            'productServiceDetailResponse' => '\\StructType\\ProductServiceDetailResponse',
            'productServiceRetailResponse' => '\\StructType\\ProductServiceRetailResponse',
            'productServiceVariantResponse' => '\\StructType\\ProductServiceVariantResponse',
            'productServiceBooleanResponse' => '\\StructType\\ProductServiceBooleanResponse',
            'productVariantType' => '\\StructType\\ProductVariantType',
            'itemIdDetailResponse' => '\\StructType\\ItemIdDetailResponse',
            'itemIdDetails' => '\\StructType\\ItemIdDetails',
            'itemIdDetailType' => '\\StructType\\ItemIdDetailType',
            'productFinishReasonListResponse' => '\\StructType\\ProductFinishReasonListResponse',
            'productFinishReasonTypeList' => '\\StructType\\ProductFinishReasonTypeList',
            'productFinishReasonType' => '\\StructType\\ProductFinishReasonType',
        );
    }
}
