<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Xml ServiceType
 * @subpackage Services
 */
class Xml extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named XmlSubmitToUrlQueryPart
     * Meta information extracted from the WSDL
     * - documentation: Transforms an Xml submit to a url query part
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\XmlSubmitToUrlQueryPart $parameters
     * @return \StructType\XmlSubmitToUrlQueryPartResponse|bool
     */
    public function XmlSubmitToUrlQueryPart(\StructType\XmlSubmitToUrlQueryPart $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->XmlSubmitToUrlQueryPart($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\XmlSubmitToUrlQueryPartResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
