<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Short ServiceType
 * @subpackage Services
 */
class Short extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ShortFormToXmlWhereClause
     * Meta information extracted from the WSDL
     * - documentation: Transforms shortform query to a PXmlQuery where section
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShortFormToXmlWhereClause $parameters
     * @return \StructType\ShortFormToXmlWhereClauseResponse|bool
     */
    public function ShortFormToXmlWhereClause(\StructType\ShortFormToXmlWhereClause $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ShortFormToXmlWhereClause($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ShortFormToXmlWhereClauseResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
