<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Calc ServiceType
 * @subpackage Services
 */
class Calc extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CalcImageScale
     * Meta information extracted from the WSDL
     * - documentation: Calculates the image dpi to use accross a series of images to make them of proportionate size and to fit each of them within a specified size.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CalcImageScale $parameters
     * @return \StructType\CalcImageScaleResponse|bool
     */
    public function CalcImageScale(\StructType\CalcImageScale $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalcImageScale($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CalcImageScaleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
