<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://perfion.lekangfilter.no:8080/Perfion/GetData.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://perfion.lekangfilter.no:8080/Perfion/GetData.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Execute ServiceType
 */
$execute = new \ServiceType\Execute($options);
/**
 * Sample call for ExecuteQuery operation/method
 */
if ($execute->ExecuteQuery(new \StructType\ExecuteQuery()) !== false) {
    print_r($execute->getResult());
} else {
    print_r($execute->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetFilterAsHtml operation/method
 */
if ($get->GetFilterAsHtml(new \StructType\GetFilterAsHtml()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFilterAsXml operation/method
 */
if ($get->GetFilterAsXml(new \StructType\GetFilterAsXml()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLanguages operation/method
 */
if ($get->GetLanguages(new \StructType\GetLanguages()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSelectableFeatures operation/method
 */
if ($get->GetSelectableFeatures(new \StructType\GetSelectableFeatures()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTypesUsedBy operation/method
 */
if ($get->GetTypesUsedBy(new \StructType\GetTypesUsedBy()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Calc ServiceType
 */
$calc = new \ServiceType\Calc($options);
/**
 * Sample call for CalcImageScale operation/method
 */
if ($calc->CalcImageScale(new \StructType\CalcImageScale()) !== false) {
    print_r($calc->getResult());
} else {
    print_r($calc->getLastError());
}
/**
 * Samples for Filter ServiceType
 */
$filter = new \ServiceType\Filter($options);
/**
 * Sample call for FilterValuesToUrlQueryPart operation/method
 */
if ($filter->FilterValuesToUrlQueryPart(new \StructType\FilterValuesToUrlQueryPart()) !== false) {
    print_r($filter->getResult());
} else {
    print_r($filter->getLastError());
}
/**
 * Samples for Xml ServiceType
 */
$xml = new \ServiceType\Xml($options);
/**
 * Sample call for XmlSubmitToUrlQueryPart operation/method
 */
if ($xml->XmlSubmitToUrlQueryPart(new \StructType\XmlSubmitToUrlQueryPart()) !== false) {
    print_r($xml->getResult());
} else {
    print_r($xml->getLastError());
}
/**
 * Samples for Short ServiceType
 */
$short = new \ServiceType\Short($options);
/**
 * Sample call for ShortFormToXmlWhereClause operation/method
 */
if ($short->ShortFormToXmlWhereClause(new \StructType\ShortFormToXmlWhereClause()) !== false) {
    print_r($short->getResult());
} else {
    print_r($short->getLastError());
}
