<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetFilterAsHtml StructType
 * @subpackage Structs
 */
class GetFilterAsHtml extends AbstractStructBase
{
    /**
     * The filterID
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $filterID;
    /**
     * The searchFeature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $searchFeature;
    /**
     * Constructor method for GetFilterAsHtml
     * @uses GetFilterAsHtml::setFilterID()
     * @uses GetFilterAsHtml::setSearchFeature()
     * @param string $filterID
     * @param string $searchFeature
     */
    public function __construct($filterID = null, $searchFeature = null)
    {
        $this
            ->setFilterID($filterID)
            ->setSearchFeature($searchFeature);
    }
    /**
     * Get filterID value
     * @return string
     */
    public function getFilterID()
    {
        return $this->filterID;
    }
    /**
     * Set filterID value
     * @param string $filterID
     * @return \StructType\GetFilterAsHtml
     */
    public function setFilterID($filterID = null)
    {
        // validation for constraint: string
        if (!is_null($filterID) && !is_string($filterID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filterID, true), gettype($filterID)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($filterID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $filterID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($filterID, true)), __LINE__);
        }
        $this->filterID = $filterID;
        return $this;
    }
    /**
     * Get searchFeature value
     * @return string|null
     */
    public function getSearchFeature()
    {
        return $this->searchFeature;
    }
    /**
     * Set searchFeature value
     * @param string $searchFeature
     * @return \StructType\GetFilterAsHtml
     */
    public function setSearchFeature($searchFeature = null)
    {
        // validation for constraint: string
        if (!is_null($searchFeature) && !is_string($searchFeature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchFeature, true), gettype($searchFeature)), __LINE__);
        }
        $this->searchFeature = $searchFeature;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetFilterAsHtml
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
