<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalcImageScale StructType
 * @subpackage Structs
 */
class CalcImageScale extends AbstractStructBase
{
    /**
     * The maxWidth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $maxWidth;
    /**
     * The maxHeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $maxHeight;
    /**
     * The imageIDs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfGuid
     */
    public $imageIDs;
    /**
     * Constructor method for CalcImageScale
     * @uses CalcImageScale::setMaxWidth()
     * @uses CalcImageScale::setMaxHeight()
     * @uses CalcImageScale::setImageIDs()
     * @param int $maxWidth
     * @param int $maxHeight
     * @param \ArrayType\ArrayOfGuid $imageIDs
     */
    public function __construct($maxWidth = null, $maxHeight = null, \ArrayType\ArrayOfGuid $imageIDs = null)
    {
        $this
            ->setMaxWidth($maxWidth)
            ->setMaxHeight($maxHeight)
            ->setImageIDs($imageIDs);
    }
    /**
     * Get maxWidth value
     * @return int
     */
    public function getMaxWidth()
    {
        return $this->maxWidth;
    }
    /**
     * Set maxWidth value
     * @param int $maxWidth
     * @return \StructType\CalcImageScale
     */
    public function setMaxWidth($maxWidth = null)
    {
        // validation for constraint: int
        if (!is_null($maxWidth) && !(is_int($maxWidth) || ctype_digit($maxWidth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxWidth, true), gettype($maxWidth)), __LINE__);
        }
        $this->maxWidth = $maxWidth;
        return $this;
    }
    /**
     * Get maxHeight value
     * @return int
     */
    public function getMaxHeight()
    {
        return $this->maxHeight;
    }
    /**
     * Set maxHeight value
     * @param int $maxHeight
     * @return \StructType\CalcImageScale
     */
    public function setMaxHeight($maxHeight = null)
    {
        // validation for constraint: int
        if (!is_null($maxHeight) && !(is_int($maxHeight) || ctype_digit($maxHeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxHeight, true), gettype($maxHeight)), __LINE__);
        }
        $this->maxHeight = $maxHeight;
        return $this;
    }
    /**
     * Get imageIDs value
     * @return \ArrayType\ArrayOfGuid|null
     */
    public function getImageIDs()
    {
        return $this->imageIDs;
    }
    /**
     * Set imageIDs value
     * @param \ArrayType\ArrayOfGuid $imageIDs
     * @return \StructType\CalcImageScale
     */
    public function setImageIDs(\ArrayType\ArrayOfGuid $imageIDs = null)
    {
        $this->imageIDs = $imageIDs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CalcImageScale
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
