<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetFilterAsHtml
     * Meta information extracted from the WSDL
     * - documentation: Get a Perfion search filter as Html
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFilterAsHtml $parameters
     * @return \StructType\GetFilterAsHtmlResponse|bool
     */
    public function GetFilterAsHtml(\StructType\GetFilterAsHtml $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFilterAsHtml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFilterAsXml
     * Meta information extracted from the WSDL
     * - documentation: Get a Perfion search filter as Xml
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFilterAsXml $parameters
     * @return \StructType\GetFilterAsXmlResponse|bool
     */
    public function GetFilterAsXml(\StructType\GetFilterAsXml $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFilterAsXml($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLanguages
     * Meta information extracted from the WSDL
     * - documentation: Required by Perfion.AddIn. Usage is not documented and this method may disappear or change in the future without warning.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLanguages $parameters
     * @return \StructType\GetLanguagesResponse|bool
     */
    public function GetLanguages(\StructType\GetLanguages $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLanguages($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSelectableFeatures
     * Meta information extracted from the WSDL
     * - documentation: Required by Perfion.AddIn. Usage is not documented and this method may disappear or change in the future without warning.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSelectableFeatures $parameters
     * @return \StructType\GetSelectableFeaturesResponse|bool
     */
    public function GetSelectableFeatures(\StructType\GetSelectableFeatures $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSelectableFeatures($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTypesUsedBy
     * Meta information extracted from the WSDL
     * - documentation: Required by Perfion.AddIn. Usage is not documented and this method may disappear or change in the future without warning.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTypesUsedBy $parameters
     * @return \StructType\GetTypesUsedByResponse|bool
     */
    public function GetTypesUsedBy(\StructType\GetTypesUsedBy $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTypesUsedBy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetFilterAsHtmlResponse|\StructType\GetFilterAsXmlResponse|\StructType\GetLanguagesResponse|\StructType\GetSelectableFeaturesResponse|\StructType\GetTypesUsedByResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
