<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Filter ServiceType
 * @subpackage Services
 */
class Filter extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named FilterValuesToUrlQueryPart
     * Meta information extracted from the WSDL
     * - documentation: Transforms a list of form names and values to a url query part
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FilterValuesToUrlQueryPart $parameters
     * @return \StructType\FilterValuesToUrlQueryPartResponse|bool
     */
    public function FilterValuesToUrlQueryPart(\StructType\FilterValuesToUrlQueryPart $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FilterValuesToUrlQueryPart($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\FilterValuesToUrlQueryPartResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
