<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Save ServiceType
 * @subpackage Services
 */
class Save extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SaveSiparis
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveSiparis $parameters
     * @return \StructType\SaveSiparisResponse|bool
     */
    public function SaveSiparis(\StructType\SaveSiparis $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveSiparis($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveKargoTakipNo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveKargoTakipNo $parameters
     * @return \StructType\SaveKargoTakipNoResponse|bool
     */
    public function SaveKargoTakipNo(\StructType\SaveKargoTakipNo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveKargoTakipNo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveSiparisKargoPaket
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveSiparisKargoPaket $parameters
     * @return \StructType\SaveSiparisKargoPaketResponse|bool
     */
    public function SaveSiparisKargoPaket(\StructType\SaveSiparisKargoPaket $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveSiparisKargoPaket($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveSiparisKargoPaketKargoTakipNo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveSiparisKargoPaketKargoTakipNo $parameters
     * @return \StructType\SaveSiparisKargoPaketKargoTakipNoResponse|bool
     */
    public function SaveSiparisKargoPaketKargoTakipNo(\StructType\SaveSiparisKargoPaketKargoTakipNo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveSiparisKargoPaketKargoTakipNo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SaveKargoTakipNoResponse|\StructType\SaveSiparisKargoPaketKargoTakipNoResponse|\StructType\SaveSiparisKargoPaketResponse|\StructType\SaveSiparisResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
