<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebMagazaFiltre StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WebMagazaFiltre
 * @subpackage Structs
 */
class WebMagazaFiltre extends AbstractStructBase
{
    /**
     * The Aktif
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Aktif;
    /**
     * The ApiSifre
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApiSifre;
    /**
     * The IlID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IlID;
    /**
     * The IletisimdeGoster
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IletisimdeGoster;
    /**
     * The MagazaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MagazaID;
    /**
     * The MagazaKodu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MagazaKodu;
    /**
     * The SiparisAdimindaGoster
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisAdimindaGoster;
    /**
     * The Tanim
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Tanim;
    /**
     * The UlkeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UlkeID;
    /**
     * Constructor method for WebMagazaFiltre
     * @uses WebMagazaFiltre::setAktif()
     * @uses WebMagazaFiltre::setApiSifre()
     * @uses WebMagazaFiltre::setIlID()
     * @uses WebMagazaFiltre::setIletisimdeGoster()
     * @uses WebMagazaFiltre::setMagazaID()
     * @uses WebMagazaFiltre::setMagazaKodu()
     * @uses WebMagazaFiltre::setSiparisAdimindaGoster()
     * @uses WebMagazaFiltre::setTanim()
     * @uses WebMagazaFiltre::setUlkeID()
     * @param int $aktif
     * @param string $apiSifre
     * @param int $ilID
     * @param int $iletisimdeGoster
     * @param int $magazaID
     * @param string $magazaKodu
     * @param int $siparisAdimindaGoster
     * @param string $tanim
     * @param int $ulkeID
     */
    public function __construct($aktif = null, $apiSifre = null, $ilID = null, $iletisimdeGoster = null, $magazaID = null, $magazaKodu = null, $siparisAdimindaGoster = null, $tanim = null, $ulkeID = null)
    {
        $this
            ->setAktif($aktif)
            ->setApiSifre($apiSifre)
            ->setIlID($ilID)
            ->setIletisimdeGoster($iletisimdeGoster)
            ->setMagazaID($magazaID)
            ->setMagazaKodu($magazaKodu)
            ->setSiparisAdimindaGoster($siparisAdimindaGoster)
            ->setTanim($tanim)
            ->setUlkeID($ulkeID);
    }
    /**
     * Get Aktif value
     * @return int|null
     */
    public function getAktif()
    {
        return $this->Aktif;
    }
    /**
     * Set Aktif value
     * @param int $aktif
     * @return \StructType\WebMagazaFiltre
     */
    public function setAktif($aktif = null)
    {
        // validation for constraint: int
        if (!is_null($aktif) && !(is_int($aktif) || ctype_digit($aktif))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aktif, true), gettype($aktif)), __LINE__);
        }
        $this->Aktif = $aktif;
        return $this;
    }
    /**
     * Get ApiSifre value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApiSifre()
    {
        return isset($this->ApiSifre) ? $this->ApiSifre : null;
    }
    /**
     * Set ApiSifre value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apiSifre
     * @return \StructType\WebMagazaFiltre
     */
    public function setApiSifre($apiSifre = null)
    {
        // validation for constraint: string
        if (!is_null($apiSifre) && !is_string($apiSifre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apiSifre, true), gettype($apiSifre)), __LINE__);
        }
        if (is_null($apiSifre) || (is_array($apiSifre) && empty($apiSifre))) {
            unset($this->ApiSifre);
        } else {
            $this->ApiSifre = $apiSifre;
        }
        return $this;
    }
    /**
     * Get IlID value
     * @return int|null
     */
    public function getIlID()
    {
        return $this->IlID;
    }
    /**
     * Set IlID value
     * @param int $ilID
     * @return \StructType\WebMagazaFiltre
     */
    public function setIlID($ilID = null)
    {
        // validation for constraint: int
        if (!is_null($ilID) && !(is_int($ilID) || ctype_digit($ilID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ilID, true), gettype($ilID)), __LINE__);
        }
        $this->IlID = $ilID;
        return $this;
    }
    /**
     * Get IletisimdeGoster value
     * @return int|null
     */
    public function getIletisimdeGoster()
    {
        return $this->IletisimdeGoster;
    }
    /**
     * Set IletisimdeGoster value
     * @param int $iletisimdeGoster
     * @return \StructType\WebMagazaFiltre
     */
    public function setIletisimdeGoster($iletisimdeGoster = null)
    {
        // validation for constraint: int
        if (!is_null($iletisimdeGoster) && !(is_int($iletisimdeGoster) || ctype_digit($iletisimdeGoster))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iletisimdeGoster, true), gettype($iletisimdeGoster)), __LINE__);
        }
        $this->IletisimdeGoster = $iletisimdeGoster;
        return $this;
    }
    /**
     * Get MagazaID value
     * @return int|null
     */
    public function getMagazaID()
    {
        return $this->MagazaID;
    }
    /**
     * Set MagazaID value
     * @param int $magazaID
     * @return \StructType\WebMagazaFiltre
     */
    public function setMagazaID($magazaID = null)
    {
        // validation for constraint: int
        if (!is_null($magazaID) && !(is_int($magazaID) || ctype_digit($magazaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($magazaID, true), gettype($magazaID)), __LINE__);
        }
        $this->MagazaID = $magazaID;
        return $this;
    }
    /**
     * Get MagazaKodu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMagazaKodu()
    {
        return isset($this->MagazaKodu) ? $this->MagazaKodu : null;
    }
    /**
     * Set MagazaKodu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $magazaKodu
     * @return \StructType\WebMagazaFiltre
     */
    public function setMagazaKodu($magazaKodu = null)
    {
        // validation for constraint: string
        if (!is_null($magazaKodu) && !is_string($magazaKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($magazaKodu, true), gettype($magazaKodu)), __LINE__);
        }
        if (is_null($magazaKodu) || (is_array($magazaKodu) && empty($magazaKodu))) {
            unset($this->MagazaKodu);
        } else {
            $this->MagazaKodu = $magazaKodu;
        }
        return $this;
    }
    /**
     * Get SiparisAdimindaGoster value
     * @return int|null
     */
    public function getSiparisAdimindaGoster()
    {
        return $this->SiparisAdimindaGoster;
    }
    /**
     * Set SiparisAdimindaGoster value
     * @param int $siparisAdimindaGoster
     * @return \StructType\WebMagazaFiltre
     */
    public function setSiparisAdimindaGoster($siparisAdimindaGoster = null)
    {
        // validation for constraint: int
        if (!is_null($siparisAdimindaGoster) && !(is_int($siparisAdimindaGoster) || ctype_digit($siparisAdimindaGoster))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siparisAdimindaGoster, true), gettype($siparisAdimindaGoster)), __LINE__);
        }
        $this->SiparisAdimindaGoster = $siparisAdimindaGoster;
        return $this;
    }
    /**
     * Get Tanim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTanim()
    {
        return isset($this->Tanim) ? $this->Tanim : null;
    }
    /**
     * Set Tanim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tanim
     * @return \StructType\WebMagazaFiltre
     */
    public function setTanim($tanim = null)
    {
        // validation for constraint: string
        if (!is_null($tanim) && !is_string($tanim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tanim, true), gettype($tanim)), __LINE__);
        }
        if (is_null($tanim) || (is_array($tanim) && empty($tanim))) {
            unset($this->Tanim);
        } else {
            $this->Tanim = $tanim;
        }
        return $this;
    }
    /**
     * Get UlkeID value
     * @return int|null
     */
    public function getUlkeID()
    {
        return $this->UlkeID;
    }
    /**
     * Set UlkeID value
     * @param int $ulkeID
     * @return \StructType\WebMagazaFiltre
     */
    public function setUlkeID($ulkeID = null)
    {
        // validation for constraint: int
        if (!is_null($ulkeID) && !(is_int($ulkeID) || ctype_digit($ulkeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ulkeID, true), gettype($ulkeID)), __LINE__);
        }
        $this->UlkeID = $ulkeID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WebMagazaFiltre
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
