<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CollateralLinkReqType StructType
 * @subpackage Structs
 */
class CollateralLinkReqType extends AbstractStructBase
{
    /**
     * The DebtObligationAccNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DebtObligationAccNumber;
    /**
     * The CollateralCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CollateralCode;
    /**
     * The BaseCalculationKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BaseCalculationKey;
    /**
     * The BaseCalculationValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $BaseCalculationValue;
    /**
     * Constructor method for CollateralLinkReqType
     * @uses CollateralLinkReqType::setDebtObligationAccNumber()
     * @uses CollateralLinkReqType::setCollateralCode()
     * @uses CollateralLinkReqType::setBaseCalculationKey()
     * @uses CollateralLinkReqType::setBaseCalculationValue()
     * @param string $debtObligationAccNumber
     * @param string $collateralCode
     * @param string $baseCalculationKey
     * @param float $baseCalculationValue
     */
    public function __construct($debtObligationAccNumber = null, $collateralCode = null, $baseCalculationKey = null, $baseCalculationValue = null)
    {
        $this
            ->setDebtObligationAccNumber($debtObligationAccNumber)
            ->setCollateralCode($collateralCode)
            ->setBaseCalculationKey($baseCalculationKey)
            ->setBaseCalculationValue($baseCalculationValue);
    }
    /**
     * Get DebtObligationAccNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDebtObligationAccNumber()
    {
        return isset($this->DebtObligationAccNumber) ? $this->DebtObligationAccNumber : null;
    }
    /**
     * Set DebtObligationAccNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $debtObligationAccNumber
     * @return \StructType\CollateralLinkReqType
     */
    public function setDebtObligationAccNumber($debtObligationAccNumber = null)
    {
        // validation for constraint: string
        if (!is_null($debtObligationAccNumber) && !is_string($debtObligationAccNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($debtObligationAccNumber, true), gettype($debtObligationAccNumber)), __LINE__);
        }
        if (is_null($debtObligationAccNumber) || (is_array($debtObligationAccNumber) && empty($debtObligationAccNumber))) {
            unset($this->DebtObligationAccNumber);
        } else {
            $this->DebtObligationAccNumber = $debtObligationAccNumber;
        }
        return $this;
    }
    /**
     * Get CollateralCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCollateralCode()
    {
        return isset($this->CollateralCode) ? $this->CollateralCode : null;
    }
    /**
     * Set CollateralCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $collateralCode
     * @return \StructType\CollateralLinkReqType
     */
    public function setCollateralCode($collateralCode = null)
    {
        // validation for constraint: string
        if (!is_null($collateralCode) && !is_string($collateralCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($collateralCode, true), gettype($collateralCode)), __LINE__);
        }
        if (is_null($collateralCode) || (is_array($collateralCode) && empty($collateralCode))) {
            unset($this->CollateralCode);
        } else {
            $this->CollateralCode = $collateralCode;
        }
        return $this;
    }
    /**
     * Get BaseCalculationKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBaseCalculationKey()
    {
        return isset($this->BaseCalculationKey) ? $this->BaseCalculationKey : null;
    }
    /**
     * Set BaseCalculationKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $baseCalculationKey
     * @return \StructType\CollateralLinkReqType
     */
    public function setBaseCalculationKey($baseCalculationKey = null)
    {
        // validation for constraint: string
        if (!is_null($baseCalculationKey) && !is_string($baseCalculationKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baseCalculationKey, true), gettype($baseCalculationKey)), __LINE__);
        }
        if (is_null($baseCalculationKey) || (is_array($baseCalculationKey) && empty($baseCalculationKey))) {
            unset($this->BaseCalculationKey);
        } else {
            $this->BaseCalculationKey = $baseCalculationKey;
        }
        return $this;
    }
    /**
     * Get BaseCalculationValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBaseCalculationValue()
    {
        return isset($this->BaseCalculationValue) ? $this->BaseCalculationValue : null;
    }
    /**
     * Set BaseCalculationValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $baseCalculationValue
     * @return \StructType\CollateralLinkReqType
     */
    public function setBaseCalculationValue($baseCalculationValue = null)
    {
        // validation for constraint: float
        if (!is_null($baseCalculationValue) && !(is_float($baseCalculationValue) || is_numeric($baseCalculationValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($baseCalculationValue, true), gettype($baseCalculationValue)), __LINE__);
        }
        if (is_null($baseCalculationValue) || (is_array($baseCalculationValue) && empty($baseCalculationValue))) {
            unset($this->BaseCalculationValue);
        } else {
            $this->BaseCalculationValue = $baseCalculationValue;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CollateralLinkReqType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
