<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://rektor.unist.hr:1443/wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://rektor.unist.hr:1443/wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Anon ServiceType
 */
$anon = new \ServiceType\Anon($options);
/**
 * Sample call for anonBinSearch operation/method
 */
if ($anon->anonBinSearch($user, $password, $base, $filter, $attribute, $md5_base64) !== false) {
    print_r($anon->getResult());
} else {
    print_r($anon->getLastError());
}
/**
 * Sample call for anonSearch operation/method
 */
if ($anon->anonSearch($base, $filter, $attribute) !== false) {
    print_r($anon->getResult());
} else {
    print_r($anon->getLastError());
}
/**
 * Samples for Ldap ServiceType
 */
$ldap = new \ServiceType\Ldap($options);
/**
 * Sample call for ldapAddAttribute operation/method
 */
if ($ldap->ldapAddAttribute($user, $password, $base, $ldap_xml) !== false) {
    print_r($ldap->getResult());
} else {
    print_r($ldap->getLastError());
}
/**
 * Sample call for ldapAddUser operation/method
 */
if ($ldap->ldapAddUser($user, $password, $base, $ldap_xml) !== false) {
    print_r($ldap->getResult());
} else {
    print_r($ldap->getLastError());
}
/**
 * Sample call for ldapAddUserLEx operation/method
 */
if ($ldap->ldapAddUserLEx($user, $password, $base, $ldap_xml) !== false) {
    print_r($ldap->getResult());
} else {
    print_r($ldap->getLastError());
}
/**
 * Sample call for ldapAddUserLE operation/method
 */
if ($ldap->ldapAddUserLE($user, $password, $base, $ldap_xml) !== false) {
    print_r($ldap->getResult());
} else {
    print_r($ldap->getLastError());
}
/**
 * Sample call for ldapAdminInfo operation/method
 */
if ($ldap->ldapAdminInfo($user, $password, $base, $uid) !== false) {
    print_r($ldap->getResult());
} else {
    print_r($ldap->getLastError());
}
/**
 * Sample call for ldapBinSearch operation/method
 */
if ($ldap->ldapBinSearch($user, $password, $base, $filter, $attribute, $md5_base64) !== false) {
    print_r($ldap->getResult());
} else {
    print_r($ldap->getLastError());
}
/**
 * Sample call for ldapBind operation/method
 */
if ($ldap->ldapBind($user, $password, $base) !== false) {
    print_r($ldap->getResult());
} else {
    print_r($ldap->getLastError());
}
/**
 * Sample call for ldapDeleteAttribute operation/method
 */
if ($ldap->ldapDeleteAttribute($user, $password, $base, $ldap_xml) !== false) {
    print_r($ldap->getResult());
} else {
    print_r($ldap->getLastError());
}
/**
 * Sample call for ldapDeleteUser operation/method
 */
if ($ldap->ldapDeleteUser($user, $password, $base, $ldap_xml) !== false) {
    print_r($ldap->getResult());
} else {
    print_r($ldap->getLastError());
}
/**
 * Sample call for ldapList operation/method
 */
if ($ldap->ldapList($user, $password, $base, $filter, $attribute, $from, $size) !== false) {
    print_r($ldap->getResult());
} else {
    print_r($ldap->getLastError());
}
/**
 * Sample call for ldapModifyAttribute operation/method
 */
if ($ldap->ldapModifyAttribute($user, $password, $base, $ldap_xml) !== false) {
    print_r($ldap->getResult());
} else {
    print_r($ldap->getLastError());
}
/**
 * Sample call for ldapOrgInfo operation/method
 */
if ($ldap->ldapOrgInfo($user, $password, $base) !== false) {
    print_r($ldap->getResult());
} else {
    print_r($ldap->getLastError());
}
/**
 * Sample call for ldapOrgAdd operation/method
 */
if ($ldap->ldapOrgAdd($user, $password, $base, $ldap_xml) !== false) {
    print_r($ldap->getResult());
} else {
    print_r($ldap->getLastError());
}
/**
 * Sample call for ldapOrgModify operation/method
 */
if ($ldap->ldapOrgModify($user, $password, $base, $ldap_xml) !== false) {
    print_r($ldap->getResult());
} else {
    print_r($ldap->getLastError());
}
/**
 * Sample call for ldapOrgDelete operation/method
 */
if ($ldap->ldapOrgDelete($user, $password, $base, $ldap_xml) !== false) {
    print_r($ldap->getResult());
} else {
    print_r($ldap->getLastError());
}
/**
 * Sample call for ldapSearch operation/method
 */
if ($ldap->ldapSearch($user, $password, $base, $filter, $attribute) !== false) {
    print_r($ldap->getResult());
} else {
    print_r($ldap->getLastError());
}
/**
 * Sample call for ldapUserExists operation/method
 */
if ($ldap->ldapUserExists($user, $password, $base, $uid) !== false) {
    print_r($ldap->getResult());
} else {
    print_r($ldap->getLastError());
}
/**
 * Sample call for ldapInfo operation/method
 */
if ($ldap->ldapInfo($user, $password, $base, $type) !== false) {
    print_r($ldap->getResult());
} else {
    print_r($ldap->getLastError());
}
/**
 * Sample call for ldapLockList operation/method
 */
if ($ldap->ldapLockList($user, $password, $base, $type) !== false) {
    print_r($ldap->getResult());
} else {
    print_r($ldap->getLastError());
}
/**
 * Sample call for ldapLDIFSync operation/method
 */
if ($ldap->ldapLDIFSync($user, $password, $base, $type) !== false) {
    print_r($ldap->getResult());
} else {
    print_r($ldap->getLastError());
}
/**
 * Sample call for ldapAdresar operation/method
 */
if ($ldap->ldapAdresar($user, $password, $base, $type) !== false) {
    print_r($ldap->getResult());
} else {
    print_r($ldap->getLastError());
}
/**
 * Sample call for ldapCertData operation/method
 */
if ($ldap->ldapCertData($user, $password, $base, $type) !== false) {
    print_r($ldap->getResult());
} else {
    print_r($ldap->getLastError());
}
/**
 * Samples for User ServiceType
 */
$user = new \ServiceType\User($options);
/**
 * Sample call for userAddAttribute operation/method
 */
if ($user->userAddAttribute($user, $password, $base, $ldap_xml) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userBinSearch operation/method
 */
if ($user->userBinSearch($user, $password, $base, $filter, $attribute, $md5_base64) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userBind operation/method
 */
if ($user->userBind($user, $password, $base) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userDeleteAttribute operation/method
 */
if ($user->userDeleteAttribute($user, $password, $base, $ldap_xml) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userModifyAttribute operation/method
 */
if ($user->userModifyAttribute($user, $password, $base, $ldap_xml) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userOrgInfo operation/method
 */
if ($user->userOrgInfo($user, $password, $base) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userSearch operation/method
 */
if ($user->userSearch($user, $password, $base, $filter, $attribute) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Samples for Edu ServiceType
 */
$edu = new \ServiceType\Edu($options);
/**
 * Sample call for eduAdresar operation/method
 */
if ($edu->eduAdresar($user, $password, $base, $type) !== false) {
    print_r($edu->getResult());
} else {
    print_r($edu->getLastError());
}
