<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for User ServiceType
 * @subpackage Services
 */
class User extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named userAddAttribute
     * Meta information extracted from the WSDL
     * - documentation: Dodaje se nova (ili prva) vrijednost navedenog atributa. (Korisnik)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @param string $ldap_xml
     * @return array|bool
     */
    public function userAddAttribute($user, $password, $base, $ldap_xml)
    {
        try {
            $this->setResult($this->getSoapClient()->userAddAttribute($user, $password, $base, $ldap_xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named userBinSearch
     * Meta information extracted from the WSDL
     * - documentation: Vraća navedene binarne atribute za sve stavke u imeniku koje zadovoljavaju navedeni filter. (Korisnik)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @param string $filter
     * @param string $attribute
     * @param string $md5_base64
     * @return array|bool
     */
    public function userBinSearch($user, $password, $base, $filter, $attribute, $md5_base64)
    {
        try {
            $this->setResult($this->getSoapClient()->userBinSearch($user, $password, $base, $filter, $attribute, $md5_base64));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named userBind
     * Meta information extracted from the WSDL
     * - documentation: Prijavljuje se u imenik. Vraća: 0 - korisnik, 1 - Administrator; datoteka, 2 - Administrator; imenik. (Korisnik)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @return array|bool
     */
    public function userBind($user, $password, $base)
    {
        try {
            $this->setResult($this->getSoapClient()->userBind($user, $password, $base));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named userDeleteAttribute
     * Meta information extracted from the WSDL
     * - documentation: Briše se vrijednost atributa (ako je navedena vrijednost briše se samo ta vrijednost inače se brišu sve vrijednosti). (Korisnik)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @param string $ldap_xml
     * @return array|bool
     */
    public function userDeleteAttribute($user, $password, $base, $ldap_xml)
    {
        try {
            $this->setResult($this->getSoapClient()->userDeleteAttribute($user, $password, $base, $ldap_xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named userModifyAttribute
     * Meta information extracted from the WSDL
     * - documentation: Mijenja se vrijednost atributa (odn. brišu se stare vrijednosti i upisuje se nove). (Korisnik)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @param string $ldap_xml
     * @return array|bool
     */
    public function userModifyAttribute($user, $password, $base, $ldap_xml)
    {
        try {
            $this->setResult($this->getSoapClient()->userModifyAttribute($user, $password, $base, $ldap_xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named userOrgInfo
     * Meta information extracted from the WSDL
     * - documentation: Vraća podatke o ustanovi u imenuku. (Korisnik) Primjer: ldapOrgInfo('test', 'test', 'dc=srce,dc=hr');
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @return array|bool
     */
    public function userOrgInfo($user, $password, $base)
    {
        try {
            $this->setResult($this->getSoapClient()->userOrgInfo($user, $password, $base));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named userSearch
     * Meta information extracted from the WSDL
     * - documentation: Vraća navedene atribute za sve stavke u imeniku koje zadovoljavaju navedeni filter. (Korisnik) Primjer: Korisnik traži atribut 'sn' i 'cn' o korisniku 'test': ldapSearch('test', 'test', 'dc=srce,dc=hr', '(uid=test)', 'sn,cn');
     * Korisnik traži atribut 'jpegPhoto' od korisnika 'test' (vrati se samo MD5 hash od slike/slika - za dohvat slike se koristi ldapBinSearch): ldapSearch('test', 'test', 'dc=srce,dc=hr', '(uid=test)', 'jpegPhoto');
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @param string $filter
     * @param string $attribute
     * @return array|bool
     */
    public function userSearch($user, $password, $base, $filter, $attribute)
    {
        try {
            $this->setResult($this->getSoapClient()->userSearch($user, $password, $base, $filter, $attribute));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
