<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ldap ServiceType
 * @subpackage Services
 */
class Ldap extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ldapAddAttribute
     * Meta information extracted from the WSDL
     * - documentation: Dodaje se nova (ili prva) vrijednost navedenog atributa. (Administrator)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @param string $ldap_xml
     * @return array|bool
     */
    public function ldapAddAttribute($user, $password, $base, $ldap_xml)
    {
        try {
            $this->setResult($this->getSoapClient()->ldapAddAttribute($user, $password, $base, $ldap_xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ldapAddUser
     * Meta information extracted from the WSDL
     * - documentation: Ovu funkciju ne bi trebalo rabiti. Dodaju se novi korisnici u imenik (obavezni atributi: cn, givenName, hrEduPersonAffiliation, hrEduPersonExpireDate, hrEduPersonHomeOrg, hrEduPersonPrimaryAffiliation, hrEduPersonUniqueID,
     * hrEduPersonUniqueNumber, l, mail, o, postalAddress, sn, uid, userPassword). (Administrator)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @param string $ldap_xml
     * @return array|bool
     */
    public function ldapAddUser($user, $password, $base, $ldap_xml)
    {
        try {
            $this->setResult($this->getSoapClient()->ldapAddUser($user, $password, $base, $ldap_xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ldapAddUserLEx
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @param string $ldap_xml
     * @return array|bool
     */
    public function ldapAddUserLEx($user, $password, $base, $ldap_xml)
    {
        try {
            $this->setResult($this->getSoapClient()->ldapAddUserLEx($user, $password, $base, $ldap_xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ldapAddUserLE
     * Meta information extracted from the WSDL
     * - documentation: Dodaju se novi korisnici u imenik uz manji broj obaveznih atributa (obavezni atributi: cn, givenName, hrEduPersonAffiliation, hrEduPersonExpireDate, hrEduPersonPrimaryAffiliation, hrEduPersonUniqueNumber, mail, sn, uid,
     * userPassword). (Administrator)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @param string $ldap_xml
     * @return array|bool
     */
    public function ldapAddUserLE($user, $password, $base, $ldap_xml)
    {
        try {
            $this->setResult($this->getSoapClient()->ldapAddUserLE($user, $password, $base, $ldap_xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ldapAdminInfo
     * Meta information extracted from the WSDL
     * - documentation: Vraća podatke o administratorima imenika. Tipovi: 0 - Korisnik, 1 - Administrator datoteka, 2 - Administrator imenik. (Administrator)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @param string $uid
     * @return array|bool
     */
    public function ldapAdminInfo($user, $password, $base, $uid)
    {
        try {
            $this->setResult($this->getSoapClient()->ldapAdminInfo($user, $password, $base, $uid));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ldapBinSearch
     * Meta information extracted from the WSDL
     * - documentation: Vraća navedene binarne atribute za sve stavke u imeniku koje zadovoljavaju navedeni filter. (Administrator)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @param string $filter
     * @param string $attribute
     * @param string $md5_base64
     * @return array|bool
     */
    public function ldapBinSearch($user, $password, $base, $filter, $attribute, $md5_base64)
    {
        try {
            $this->setResult($this->getSoapClient()->ldapBinSearch($user, $password, $base, $filter, $attribute, $md5_base64));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ldapBind
     * Meta information extracted from the WSDL
     * - documentation: Prijavljuje se u imenik. Vraća: 0 - korisnik, 1 - Administrator; datoteka, 2 - Administrator; imenik. (Administrator)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @return array|bool
     */
    public function ldapBind($user, $password, $base)
    {
        try {
            $this->setResult($this->getSoapClient()->ldapBind($user, $password, $base));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ldapDeleteAttribute
     * Meta information extracted from the WSDL
     * - documentation: Briše se vrijednost atributa (ako je navedena vrijednost briše se samo ta vrijednost inače se brišu sve vrijednosti). (Administrator
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @param string $ldap_xml
     * @return array|bool
     */
    public function ldapDeleteAttribute($user, $password, $base, $ldap_xml)
    {
        try {
            $this->setResult($this->getSoapClient()->ldapDeleteAttribute($user, $password, $base, $ldap_xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ldapDeleteUser
     * Meta information extracted from the WSDL
     * - documentation: Briše se veći broj korisnika iz imenika. (Administrator)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @param string $ldap_xml
     * @return array|bool
     */
    public function ldapDeleteUser($user, $password, $base, $ldap_xml)
    {
        try {
            $this->setResult($this->getSoapClient()->ldapDeleteUser($user, $password, $base, $ldap_xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ldapList
     * Meta information extracted from the WSDL
     * - documentation: Vraća navedene atribute za sve stavke u imeniku koje zadovoljavaju navedeni filter i rezultata se ispisuje po stranicama. (Administrator)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @param string $filter
     * @param string $attribute
     * @param string $from
     * @param string $size
     * @return array|bool
     */
    public function ldapList($user, $password, $base, $filter, $attribute, $from, $size)
    {
        try {
            $this->setResult($this->getSoapClient()->ldapList($user, $password, $base, $filter, $attribute, $from, $size));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ldapModifyAttribute
     * Meta information extracted from the WSDL
     * - documentation: Mijenja se vrijednost atributa (odn. brišu se stare vrijednosti i upisuje se nove). (Administrator)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @param string $ldap_xml
     * @return array|bool
     */
    public function ldapModifyAttribute($user, $password, $base, $ldap_xml)
    {
        try {
            $this->setResult($this->getSoapClient()->ldapModifyAttribute($user, $password, $base, $ldap_xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ldapOrgInfo
     * Meta information extracted from the WSDL
     * - documentation: Vraća podatke o ustanovi u imenuku. (Administrator) Primjer: ldapOrgInfo('test', 'test', 'dc=srce,dc=hr');
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @return array|bool
     */
    public function ldapOrgInfo($user, $password, $base)
    {
        try {
            $this->setResult($this->getSoapClient()->ldapOrgInfo($user, $password, $base));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ldapOrgAdd
     * Meta information extracted from the WSDL
     * - documentation: Mijenja podatke o ustanovi u imenuku. (Administrator).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @param string $ldap_xml
     * @return array|bool
     */
    public function ldapOrgAdd($user, $password, $base, $ldap_xml)
    {
        try {
            $this->setResult($this->getSoapClient()->ldapOrgAdd($user, $password, $base, $ldap_xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ldapOrgModify
     * Meta information extracted from the WSDL
     * - documentation: Mijenja podatke o ustanovi u imenuku. (Administrator).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @param string $ldap_xml
     * @return array|bool
     */
    public function ldapOrgModify($user, $password, $base, $ldap_xml)
    {
        try {
            $this->setResult($this->getSoapClient()->ldapOrgModify($user, $password, $base, $ldap_xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ldapOrgDelete
     * Meta information extracted from the WSDL
     * - documentation: Mijenja podatke o ustanovi u imenuku. (Administrator).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @param string $ldap_xml
     * @return array|bool
     */
    public function ldapOrgDelete($user, $password, $base, $ldap_xml)
    {
        try {
            $this->setResult($this->getSoapClient()->ldapOrgDelete($user, $password, $base, $ldap_xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ldapSearch
     * Meta information extracted from the WSDL
     * - documentation: Vraća navedene atribute za sve stavke u imeniku koje zadovoljavaju navedeni filter. (Administrator) Primjer: Administrator traži atribut 'sn' i 'cn' o korisniku 'test': ldapSearch('test', 'test', 'dc=srce,dc=hr', '(uid=test)',
     * 'sn,cn'); Administrator traži atribut 'jpegPhoto' od korisnika 'test' (vrati se samo MD5 hash od slike/slika - za dohvat slike se koristi ldapBinSearch): ldapSearch('test', 'test', 'dc=srce,dc=hr', '(uid=test)', 'jpegPhoto');
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @param string $filter
     * @param string $attribute
     * @return array|bool
     */
    public function ldapSearch($user, $password, $base, $filter, $attribute)
    {
        try {
            $this->setResult($this->getSoapClient()->ldapSearch($user, $password, $base, $filter, $attribute));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ldapUserExists
     * Meta information extracted from the WSDL
     * - documentation: Provjerava postoji li kosrinik s navedenom oznakom u imeniku. (Administrator)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @param string $uid
     * @return array|bool
     */
    public function ldapUserExists($user, $password, $base, $uid)
    {
        try {
            $this->setResult($this->getSoapClient()->ldapUserExists($user, $password, $base, $uid));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ldapInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @param string $type
     * @return array|bool
     */
    public function ldapInfo($user, $password, $base, $type)
    {
        try {
            $this->setResult($this->getSoapClient()->ldapInfo($user, $password, $base, $type));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ldapLockList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @param string $type
     * @return array|bool
     */
    public function ldapLockList($user, $password, $base, $type)
    {
        try {
            $this->setResult($this->getSoapClient()->ldapLockList($user, $password, $base, $type));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ldapLDIFSync
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @param string $type
     * @return array|bool
     */
    public function ldapLDIFSync($user, $password, $base, $type)
    {
        try {
            $this->setResult($this->getSoapClient()->ldapLDIFSync($user, $password, $base, $type));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ldapAdresar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @param string $type
     * @return array|bool
     */
    public function ldapAdresar($user, $password, $base, $type)
    {
        try {
            $this->setResult($this->getSoapClient()->ldapAdresar($user, $password, $base, $type));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ldapCertData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @param string $type
     * @return array|bool
     */
    public function ldapCertData($user, $password, $base, $type)
    {
        try {
            $this->setResult($this->getSoapClient()->ldapCertData($user, $password, $base, $type));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
