<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Edu ServiceType
 * @subpackage Services
 */
class Edu extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named eduAdresar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @param string $type
     * @return array|bool
     */
    public function eduAdresar($user, $password, $base, $type)
    {
        try {
            $this->setResult($this->getSoapClient()->eduAdresar($user, $password, $base, $type));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
