<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Anon ServiceType
 * @subpackage Services
 */
class Anon extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named anonBinSearch
     * Meta information extracted from the WSDL
     * - documentation: Vraća navedene binarne atribute za sve stavke u imeniku koje zadovoljavaju navedeni filter. (Anonymous)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $user
     * @param string $password
     * @param string $base
     * @param string $filter
     * @param string $attribute
     * @param string $md5_base64
     * @return array|bool
     */
    public function anonBinSearch($user, $password, $base, $filter, $attribute, $md5_base64)
    {
        try {
            $this->setResult($this->getSoapClient()->anonBinSearch($user, $password, $base, $filter, $attribute, $md5_base64));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named anonSearch
     * Meta information extracted from the WSDL
     * - documentation: Vraća navedene atribute za sve stavke u imeniku koje zadovoljavaju navedeni filter. (Anonymous) Primjer: Korisnik traži atribut 'sn' i 'cn' o korisniku 'test': Search('dc=srce,dc=hr', '(uid=test)', 'sn,cn'); Korisnik traži atribut
     * 'jpegPhoto' od korisnika 'test' (vrati se samo MD5 hash od slike/slika - za dohvat slike se koristi ldapBinSearch): Search('dc=srce,dc=hr', '(uid=test)', 'jpegPhoto');
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $base
     * @param string $filter
     * @param string $attribute
     * @return array|bool
     */
    public function anonSearch($base, $filter, $attribute)
    {
        try {
            $this->setResult($this->getSoapClient()->anonSearch($base, $filter, $attribute));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
