<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StatusMessagesType StructType
 * @subpackage Structs
 */
class StatusMessagesType extends AbstractStructBase
{
    /**
     * The ApplicationID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ApplicationID;
    /**
     * The MessageCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MessageCode;
    /**
     * The MessageDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MessageDescription;
    /**
     * The MessageType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MessageType;
    /**
     * Constructor method for StatusMessagesType
     * @uses StatusMessagesType::setApplicationID()
     * @uses StatusMessagesType::setMessageCode()
     * @uses StatusMessagesType::setMessageDescription()
     * @uses StatusMessagesType::setMessageType()
     * @param string $applicationID
     * @param string $messageCode
     * @param string $messageDescription
     * @param string $messageType
     */
    public function __construct($applicationID = null, $messageCode = null, $messageDescription = null, $messageType = null)
    {
        $this
            ->setApplicationID($applicationID)
            ->setMessageCode($messageCode)
            ->setMessageDescription($messageDescription)
            ->setMessageType($messageType);
    }
    /**
     * Get ApplicationID value
     * @return string|null
     */
    public function getApplicationID()
    {
        return $this->ApplicationID;
    }
    /**
     * Set ApplicationID value
     * @param string $applicationID
     * @return \StructType\StatusMessagesType
     */
    public function setApplicationID($applicationID = null)
    {
        // validation for constraint: string
        if (!is_null($applicationID) && !is_string($applicationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationID, true), gettype($applicationID)), __LINE__);
        }
        $this->ApplicationID = $applicationID;
        return $this;
    }
    /**
     * Get MessageCode value
     * @return string|null
     */
    public function getMessageCode()
    {
        return $this->MessageCode;
    }
    /**
     * Set MessageCode value
     * @param string $messageCode
     * @return \StructType\StatusMessagesType
     */
    public function setMessageCode($messageCode = null)
    {
        // validation for constraint: string
        if (!is_null($messageCode) && !is_string($messageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageCode, true), gettype($messageCode)), __LINE__);
        }
        $this->MessageCode = $messageCode;
        return $this;
    }
    /**
     * Get MessageDescription value
     * @return string|null
     */
    public function getMessageDescription()
    {
        return $this->MessageDescription;
    }
    /**
     * Set MessageDescription value
     * @param string $messageDescription
     * @return \StructType\StatusMessagesType
     */
    public function setMessageDescription($messageDescription = null)
    {
        // validation for constraint: string
        if (!is_null($messageDescription) && !is_string($messageDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageDescription, true), gettype($messageDescription)), __LINE__);
        }
        $this->MessageDescription = $messageDescription;
        return $this;
    }
    /**
     * Get MessageType value
     * @return string|null
     */
    public function getMessageType()
    {
        return $this->MessageType;
    }
    /**
     * Set MessageType value
     * @param string $messageType
     * @return \StructType\StatusMessagesType
     */
    public function setMessageType($messageType = null)
    {
        // validation for constraint: string
        if (!is_null($messageType) && !is_string($messageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageType, true), gettype($messageType)), __LINE__);
        }
        $this->MessageType = $messageType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StatusMessagesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
