<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoanEntityUDFInputType StructType
 * @subpackage Structs
 */
class LoanEntityUDFInputType extends AbstractStructBase
{
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Operation;
    /**
     * The LoanEntityUDFDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LoanEntityUDFType
     */
    public $LoanEntityUDFDetails;
    /**
     * Constructor method for LoanEntityUDFInputType
     * @uses LoanEntityUDFInputType::setOperation()
     * @uses LoanEntityUDFInputType::setLoanEntityUDFDetails()
     * @param string $operation
     * @param \StructType\LoanEntityUDFType $loanEntityUDFDetails
     */
    public function __construct($operation = null, \StructType\LoanEntityUDFType $loanEntityUDFDetails = null)
    {
        $this
            ->setOperation($operation)
            ->setLoanEntityUDFDetails($loanEntityUDFDetails);
    }
    /**
     * Get Operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @param string $operation
     * @return \StructType\LoanEntityUDFInputType
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: string
        if (!is_null($operation) && !is_string($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operation, true), gettype($operation)), __LINE__);
        }
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Get LoanEntityUDFDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LoanEntityUDFType|null
     */
    public function getLoanEntityUDFDetails()
    {
        return isset($this->LoanEntityUDFDetails) ? $this->LoanEntityUDFDetails : null;
    }
    /**
     * Set LoanEntityUDFDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\LoanEntityUDFType $loanEntityUDFDetails
     * @return \StructType\LoanEntityUDFInputType
     */
    public function setLoanEntityUDFDetails(\StructType\LoanEntityUDFType $loanEntityUDFDetails = null)
    {
        if (is_null($loanEntityUDFDetails) || (is_array($loanEntityUDFDetails) && empty($loanEntityUDFDetails))) {
            unset($this->LoanEntityUDFDetails);
        } else {
            $this->LoanEntityUDFDetails = $loanEntityUDFDetails;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LoanEntityUDFInputType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
