<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoanEntityUDFType StructType
 * @subpackage Structs
 */
class LoanEntityUDFType extends AbstractStructBase
{
    /**
     * The LoanAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LoanAccount;
    /**
     * The PayAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayAccount;
    /**
     * The MatchAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MatchAccount;
    /**
     * The IdentificationDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IdentificationDetails;
    /**
     * The AROCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AROCode;
    /**
     * The DSOCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DSOCode;
    /**
     * The SectorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SectorCode;
    /**
     * The ApprovedDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApprovedDate;
    /**
     * The Channel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Channel;
    /**
     * The EmpCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmpCode;
    /**
     * The DeptCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeptCode;
    /**
     * The DistrCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistrCode;
    /**
     * The AnnuityType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AnnuityType;
    /**
     * The AuthID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuthID;
    /**
     * The MemoNote
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MemoNote;
    /**
     * The RelegatedDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RelegatedDate;
    /**
     * The ReviewedDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReviewedDate;
    /**
     * The CorpFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CorpFlag;
    /**
     * The ReasonFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReasonFlag;
    /**
     * The GroupID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupID;
    /**
     * The PersonalNum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonalNum;
    /**
     * The BorrowerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BorrowerID;
    /**
     * Constructor method for LoanEntityUDFType
     * @uses LoanEntityUDFType::setLoanAccount()
     * @uses LoanEntityUDFType::setPayAccount()
     * @uses LoanEntityUDFType::setMatchAccount()
     * @uses LoanEntityUDFType::setIdentificationDetails()
     * @uses LoanEntityUDFType::setAROCode()
     * @uses LoanEntityUDFType::setDSOCode()
     * @uses LoanEntityUDFType::setSectorCode()
     * @uses LoanEntityUDFType::setApprovedDate()
     * @uses LoanEntityUDFType::setChannel()
     * @uses LoanEntityUDFType::setEmpCode()
     * @uses LoanEntityUDFType::setDeptCode()
     * @uses LoanEntityUDFType::setDistrCode()
     * @uses LoanEntityUDFType::setAnnuityType()
     * @uses LoanEntityUDFType::setAuthID()
     * @uses LoanEntityUDFType::setMemoNote()
     * @uses LoanEntityUDFType::setRelegatedDate()
     * @uses LoanEntityUDFType::setReviewedDate()
     * @uses LoanEntityUDFType::setCorpFlag()
     * @uses LoanEntityUDFType::setReasonFlag()
     * @uses LoanEntityUDFType::setGroupID()
     * @uses LoanEntityUDFType::setPersonalNum()
     * @uses LoanEntityUDFType::setBorrowerID()
     * @param string $loanAccount
     * @param string $payAccount
     * @param string $matchAccount
     * @param string $identificationDetails
     * @param string $aROCode
     * @param string $dSOCode
     * @param string $sectorCode
     * @param string $approvedDate
     * @param string $channel
     * @param string $empCode
     * @param string $deptCode
     * @param string $distrCode
     * @param string $annuityType
     * @param string $authID
     * @param string $memoNote
     * @param string $relegatedDate
     * @param string $reviewedDate
     * @param string $corpFlag
     * @param string $reasonFlag
     * @param string $groupID
     * @param string $personalNum
     * @param string $borrowerID
     */
    public function __construct($loanAccount = null, $payAccount = null, $matchAccount = null, $identificationDetails = null, $aROCode = null, $dSOCode = null, $sectorCode = null, $approvedDate = null, $channel = null, $empCode = null, $deptCode = null, $distrCode = null, $annuityType = null, $authID = null, $memoNote = null, $relegatedDate = null, $reviewedDate = null, $corpFlag = null, $reasonFlag = null, $groupID = null, $personalNum = null, $borrowerID = null)
    {
        $this
            ->setLoanAccount($loanAccount)
            ->setPayAccount($payAccount)
            ->setMatchAccount($matchAccount)
            ->setIdentificationDetails($identificationDetails)
            ->setAROCode($aROCode)
            ->setDSOCode($dSOCode)
            ->setSectorCode($sectorCode)
            ->setApprovedDate($approvedDate)
            ->setChannel($channel)
            ->setEmpCode($empCode)
            ->setDeptCode($deptCode)
            ->setDistrCode($distrCode)
            ->setAnnuityType($annuityType)
            ->setAuthID($authID)
            ->setMemoNote($memoNote)
            ->setRelegatedDate($relegatedDate)
            ->setReviewedDate($reviewedDate)
            ->setCorpFlag($corpFlag)
            ->setReasonFlag($reasonFlag)
            ->setGroupID($groupID)
            ->setPersonalNum($personalNum)
            ->setBorrowerID($borrowerID);
    }
    /**
     * Get LoanAccount value
     * @return string
     */
    public function getLoanAccount()
    {
        return $this->LoanAccount;
    }
    /**
     * Set LoanAccount value
     * @param string $loanAccount
     * @return \StructType\LoanEntityUDFType
     */
    public function setLoanAccount($loanAccount = null)
    {
        // validation for constraint: string
        if (!is_null($loanAccount) && !is_string($loanAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loanAccount, true), gettype($loanAccount)), __LINE__);
        }
        $this->LoanAccount = $loanAccount;
        return $this;
    }
    /**
     * Get PayAccount value
     * @return string|null
     */
    public function getPayAccount()
    {
        return $this->PayAccount;
    }
    /**
     * Set PayAccount value
     * @param string $payAccount
     * @return \StructType\LoanEntityUDFType
     */
    public function setPayAccount($payAccount = null)
    {
        // validation for constraint: string
        if (!is_null($payAccount) && !is_string($payAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payAccount, true), gettype($payAccount)), __LINE__);
        }
        $this->PayAccount = $payAccount;
        return $this;
    }
    /**
     * Get MatchAccount value
     * @return string|null
     */
    public function getMatchAccount()
    {
        return $this->MatchAccount;
    }
    /**
     * Set MatchAccount value
     * @param string $matchAccount
     * @return \StructType\LoanEntityUDFType
     */
    public function setMatchAccount($matchAccount = null)
    {
        // validation for constraint: string
        if (!is_null($matchAccount) && !is_string($matchAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matchAccount, true), gettype($matchAccount)), __LINE__);
        }
        $this->MatchAccount = $matchAccount;
        return $this;
    }
    /**
     * Get IdentificationDetails value
     * @return string|null
     */
    public function getIdentificationDetails()
    {
        return $this->IdentificationDetails;
    }
    /**
     * Set IdentificationDetails value
     * @param string $identificationDetails
     * @return \StructType\LoanEntityUDFType
     */
    public function setIdentificationDetails($identificationDetails = null)
    {
        // validation for constraint: string
        if (!is_null($identificationDetails) && !is_string($identificationDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificationDetails, true), gettype($identificationDetails)), __LINE__);
        }
        $this->IdentificationDetails = $identificationDetails;
        return $this;
    }
    /**
     * Get AROCode value
     * @return string|null
     */
    public function getAROCode()
    {
        return $this->AROCode;
    }
    /**
     * Set AROCode value
     * @param string $aROCode
     * @return \StructType\LoanEntityUDFType
     */
    public function setAROCode($aROCode = null)
    {
        // validation for constraint: string
        if (!is_null($aROCode) && !is_string($aROCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aROCode, true), gettype($aROCode)), __LINE__);
        }
        $this->AROCode = $aROCode;
        return $this;
    }
    /**
     * Get DSOCode value
     * @return string|null
     */
    public function getDSOCode()
    {
        return $this->DSOCode;
    }
    /**
     * Set DSOCode value
     * @param string $dSOCode
     * @return \StructType\LoanEntityUDFType
     */
    public function setDSOCode($dSOCode = null)
    {
        // validation for constraint: string
        if (!is_null($dSOCode) && !is_string($dSOCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dSOCode, true), gettype($dSOCode)), __LINE__);
        }
        $this->DSOCode = $dSOCode;
        return $this;
    }
    /**
     * Get SectorCode value
     * @return string|null
     */
    public function getSectorCode()
    {
        return $this->SectorCode;
    }
    /**
     * Set SectorCode value
     * @param string $sectorCode
     * @return \StructType\LoanEntityUDFType
     */
    public function setSectorCode($sectorCode = null)
    {
        // validation for constraint: string
        if (!is_null($sectorCode) && !is_string($sectorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorCode, true), gettype($sectorCode)), __LINE__);
        }
        $this->SectorCode = $sectorCode;
        return $this;
    }
    /**
     * Get ApprovedDate value
     * @return string|null
     */
    public function getApprovedDate()
    {
        return $this->ApprovedDate;
    }
    /**
     * Set ApprovedDate value
     * @param string $approvedDate
     * @return \StructType\LoanEntityUDFType
     */
    public function setApprovedDate($approvedDate = null)
    {
        // validation for constraint: string
        if (!is_null($approvedDate) && !is_string($approvedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approvedDate, true), gettype($approvedDate)), __LINE__);
        }
        $this->ApprovedDate = $approvedDate;
        return $this;
    }
    /**
     * Get Channel value
     * @return string|null
     */
    public function getChannel()
    {
        return $this->Channel;
    }
    /**
     * Set Channel value
     * @param string $channel
     * @return \StructType\LoanEntityUDFType
     */
    public function setChannel($channel = null)
    {
        // validation for constraint: string
        if (!is_null($channel) && !is_string($channel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($channel, true), gettype($channel)), __LINE__);
        }
        $this->Channel = $channel;
        return $this;
    }
    /**
     * Get EmpCode value
     * @return string|null
     */
    public function getEmpCode()
    {
        return $this->EmpCode;
    }
    /**
     * Set EmpCode value
     * @param string $empCode
     * @return \StructType\LoanEntityUDFType
     */
    public function setEmpCode($empCode = null)
    {
        // validation for constraint: string
        if (!is_null($empCode) && !is_string($empCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($empCode, true), gettype($empCode)), __LINE__);
        }
        $this->EmpCode = $empCode;
        return $this;
    }
    /**
     * Get DeptCode value
     * @return string|null
     */
    public function getDeptCode()
    {
        return $this->DeptCode;
    }
    /**
     * Set DeptCode value
     * @param string $deptCode
     * @return \StructType\LoanEntityUDFType
     */
    public function setDeptCode($deptCode = null)
    {
        // validation for constraint: string
        if (!is_null($deptCode) && !is_string($deptCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deptCode, true), gettype($deptCode)), __LINE__);
        }
        $this->DeptCode = $deptCode;
        return $this;
    }
    /**
     * Get DistrCode value
     * @return string|null
     */
    public function getDistrCode()
    {
        return $this->DistrCode;
    }
    /**
     * Set DistrCode value
     * @param string $distrCode
     * @return \StructType\LoanEntityUDFType
     */
    public function setDistrCode($distrCode = null)
    {
        // validation for constraint: string
        if (!is_null($distrCode) && !is_string($distrCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distrCode, true), gettype($distrCode)), __LINE__);
        }
        $this->DistrCode = $distrCode;
        return $this;
    }
    /**
     * Get AnnuityType value
     * @return string|null
     */
    public function getAnnuityType()
    {
        return $this->AnnuityType;
    }
    /**
     * Set AnnuityType value
     * @param string $annuityType
     * @return \StructType\LoanEntityUDFType
     */
    public function setAnnuityType($annuityType = null)
    {
        // validation for constraint: string
        if (!is_null($annuityType) && !is_string($annuityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($annuityType, true), gettype($annuityType)), __LINE__);
        }
        $this->AnnuityType = $annuityType;
        return $this;
    }
    /**
     * Get AuthID value
     * @return string|null
     */
    public function getAuthID()
    {
        return $this->AuthID;
    }
    /**
     * Set AuthID value
     * @param string $authID
     * @return \StructType\LoanEntityUDFType
     */
    public function setAuthID($authID = null)
    {
        // validation for constraint: string
        if (!is_null($authID) && !is_string($authID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authID, true), gettype($authID)), __LINE__);
        }
        $this->AuthID = $authID;
        return $this;
    }
    /**
     * Get MemoNote value
     * @return string|null
     */
    public function getMemoNote()
    {
        return $this->MemoNote;
    }
    /**
     * Set MemoNote value
     * @param string $memoNote
     * @return \StructType\LoanEntityUDFType
     */
    public function setMemoNote($memoNote = null)
    {
        // validation for constraint: string
        if (!is_null($memoNote) && !is_string($memoNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memoNote, true), gettype($memoNote)), __LINE__);
        }
        $this->MemoNote = $memoNote;
        return $this;
    }
    /**
     * Get RelegatedDate value
     * @return string|null
     */
    public function getRelegatedDate()
    {
        return $this->RelegatedDate;
    }
    /**
     * Set RelegatedDate value
     * @param string $relegatedDate
     * @return \StructType\LoanEntityUDFType
     */
    public function setRelegatedDate($relegatedDate = null)
    {
        // validation for constraint: string
        if (!is_null($relegatedDate) && !is_string($relegatedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relegatedDate, true), gettype($relegatedDate)), __LINE__);
        }
        $this->RelegatedDate = $relegatedDate;
        return $this;
    }
    /**
     * Get ReviewedDate value
     * @return string|null
     */
    public function getReviewedDate()
    {
        return $this->ReviewedDate;
    }
    /**
     * Set ReviewedDate value
     * @param string $reviewedDate
     * @return \StructType\LoanEntityUDFType
     */
    public function setReviewedDate($reviewedDate = null)
    {
        // validation for constraint: string
        if (!is_null($reviewedDate) && !is_string($reviewedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reviewedDate, true), gettype($reviewedDate)), __LINE__);
        }
        $this->ReviewedDate = $reviewedDate;
        return $this;
    }
    /**
     * Get CorpFlag value
     * @return string|null
     */
    public function getCorpFlag()
    {
        return $this->CorpFlag;
    }
    /**
     * Set CorpFlag value
     * @param string $corpFlag
     * @return \StructType\LoanEntityUDFType
     */
    public function setCorpFlag($corpFlag = null)
    {
        // validation for constraint: string
        if (!is_null($corpFlag) && !is_string($corpFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($corpFlag, true), gettype($corpFlag)), __LINE__);
        }
        $this->CorpFlag = $corpFlag;
        return $this;
    }
    /**
     * Get ReasonFlag value
     * @return string|null
     */
    public function getReasonFlag()
    {
        return $this->ReasonFlag;
    }
    /**
     * Set ReasonFlag value
     * @param string $reasonFlag
     * @return \StructType\LoanEntityUDFType
     */
    public function setReasonFlag($reasonFlag = null)
    {
        // validation for constraint: string
        if (!is_null($reasonFlag) && !is_string($reasonFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonFlag, true), gettype($reasonFlag)), __LINE__);
        }
        $this->ReasonFlag = $reasonFlag;
        return $this;
    }
    /**
     * Get GroupID value
     * @return string|null
     */
    public function getGroupID()
    {
        return $this->GroupID;
    }
    /**
     * Set GroupID value
     * @param string $groupID
     * @return \StructType\LoanEntityUDFType
     */
    public function setGroupID($groupID = null)
    {
        // validation for constraint: string
        if (!is_null($groupID) && !is_string($groupID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupID, true), gettype($groupID)), __LINE__);
        }
        $this->GroupID = $groupID;
        return $this;
    }
    /**
     * Get PersonalNum value
     * @return string|null
     */
    public function getPersonalNum()
    {
        return $this->PersonalNum;
    }
    /**
     * Set PersonalNum value
     * @param string $personalNum
     * @return \StructType\LoanEntityUDFType
     */
    public function setPersonalNum($personalNum = null)
    {
        // validation for constraint: string
        if (!is_null($personalNum) && !is_string($personalNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personalNum, true), gettype($personalNum)), __LINE__);
        }
        $this->PersonalNum = $personalNum;
        return $this;
    }
    /**
     * Get BorrowerID value
     * @return string|null
     */
    public function getBorrowerID()
    {
        return $this->BorrowerID;
    }
    /**
     * Set BorrowerID value
     * @param string $borrowerID
     * @return \StructType\LoanEntityUDFType
     */
    public function setBorrowerID($borrowerID = null)
    {
        // validation for constraint: string
        if (!is_null($borrowerID) && !is_string($borrowerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($borrowerID, true), gettype($borrowerID)), __LINE__);
        }
        $this->BorrowerID = $borrowerID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LoanEntityUDFType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
