<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoanEntityUDFOutputType StructType
 * @subpackage Structs
 */
class LoanEntityUDFOutputType extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Result;
    /**
     * The LoanEntityUDFDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LoanEntityUDFType
     */
    public $LoanEntityUDFDetails;
    /**
     * Constructor method for LoanEntityUDFOutputType
     * @uses LoanEntityUDFOutputType::setResult()
     * @uses LoanEntityUDFOutputType::setLoanEntityUDFDetails()
     * @param string $result
     * @param \StructType\LoanEntityUDFType $loanEntityUDFDetails
     */
    public function __construct($result = null, \StructType\LoanEntityUDFType $loanEntityUDFDetails = null)
    {
        $this
            ->setResult($result)
            ->setLoanEntityUDFDetails($loanEntityUDFDetails);
    }
    /**
     * Get Result value
     * @return string|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param string $result
     * @return \StructType\LoanEntityUDFOutputType
     */
    public function setResult($result = null)
    {
        // validation for constraint: string
        if (!is_null($result) && !is_string($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->Result = $result;
        return $this;
    }
    /**
     * Get LoanEntityUDFDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LoanEntityUDFType|null
     */
    public function getLoanEntityUDFDetails()
    {
        return isset($this->LoanEntityUDFDetails) ? $this->LoanEntityUDFDetails : null;
    }
    /**
     * Set LoanEntityUDFDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\LoanEntityUDFType $loanEntityUDFDetails
     * @return \StructType\LoanEntityUDFOutputType
     */
    public function setLoanEntityUDFDetails(\StructType\LoanEntityUDFType $loanEntityUDFDetails = null)
    {
        if (is_null($loanEntityUDFDetails) || (is_array($loanEntityUDFDetails) && empty($loanEntityUDFDetails))) {
            unset($this->LoanEntityUDFDetails);
        } else {
            $this->LoanEntityUDFDetails = $loanEntityUDFDetails;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LoanEntityUDFOutputType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
